/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.literal.OlapLongLiteralInstr;

public class OlapSubsetFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "Subset";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 1: 
                case 2: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapSubsetFunction() {
        super(NAME, ARGS);
    }

    @Override
    public int getLambdaLimit(OlapInstr[] args) {
        OlapInstr start;
        if (args.length >= 3 && (start = args[1]) instanceof OlapLongLiteralInstr) {
            OlapLongLiteralInstr startI = (OlapLongLiteralInstr)start;
            int startV = startI.getValue().intValue();
            if (startV < 0) {
                return 0;
            }
            OlapInstr count = args[2];
            if (count instanceof OlapLongLiteralInstr) {
                OlapLongLiteralInstr countI = (OlapLongLiteralInstr)count;
                int countV = countI.getValue().intValue();
                if (countV < 0) {
                    return 0;
                }
                return startV + countV;
            }
        }
        return -1;
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapTupleSet<? extends OlapTuple> set = args.toSet(context, 0, true);
        if (set == null) {
            return OlapSetFactory.empty();
        }
        int start = args.toInteger(context, 1);
        int count = -1;
        if (!args.isMissingArg(2) && (count = args.toInteger(context, 2)) < 0) {
            return OlapSetFactory.empty();
        }
        return set.subset(start, count);
    }
}

