/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapAbstractIteratorFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;

public class OlapStripCalculatedMembersFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "StripCalculatedMembers";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapStripCalculatedMembersFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "set");
        if (arg0.isMdxNull()) {
            return OlapSetFactory.empty();
        }
        OlapTupleSet<? extends OlapTuple> set = args.toSet(context, 0);
        OlapIterator<OlapTuple> filtered = OlapIteratorFactory.filter(set.getIterator(false), RemoveCalculatedIteratorFilter.INSTANCE);
        return OlapSetFactory.instance(filtered);
    }

    private static class RemoveCalculatedIteratorFilter
    implements OlapAbstractIteratorFilter<OlapTuple> {
        public static RemoveCalculatedIteratorFilter INSTANCE = new RemoveCalculatedIteratorFilter();

        private RemoveCalculatedIteratorFilter() {
        }

        @Override
        public boolean accept(OlapTuple tuple) {
            int memberCount = tuple.getMemberCount();
            for (int idx = 0; idx < memberCount; ++idx) {
                OlapMember member = tuple.getMember(idx);
                if (!member.isCalculated()) continue;
                return false;
            }
            return true;
        }

        @Override
        public IOlapIteratorFilter<OlapTuple> newInstance() {
            return this;
        }
    }
}

