/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapAbstractIteratorFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapLazyDistinctCollection;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapSetComplementFunction
extends OlapNonScalarEntityFunction {
    public static final OlapSetComplementFunction INSTANCE = new OlapSetComplementFunction();
    public static final String NAME = "Set Complement Operator";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    private OlapSetComplementFunction() {
        super(NAME, ARGS);
    }

    public OlapTupleSet<? extends OlapTuple> complement(IOlapPrepareContext context, OlapEntity operand) {
        if (!operand.isToSetApplicable(context)) {
            return (OlapTupleSet)this.onFunctionArgTypeMismatchError(context, 0, "set(member)", operand.getFriendlyTypeName());
        }
        OlapTupleSet<? extends OlapTuple> operandAsSet = operand.toSet(context);
        OlapIterator<OlapTuple> operandAsSetIterator = operandAsSet.getIterator(false);
        IOlapEvaluationExceptionContext errContext = context.snapshotForError();
        OlapMemberFilter memberFilter = context.getMemberFilter();
        ComplementIterator complement = new ComplementIterator(this, errContext, memberFilter, operandAsSetIterator);
        return OlapSetFactory.instance(complement);
    }

    class ComplementIterator
    extends OlapBaseIterator<OlapTuple> {
        private final IOlapEvaluationExceptionContext errContext;
        private final OlapMemberFilter memberFilter;
        private final OlapIterator<OlapTuple> operandAsSetIterator;
        private OlapAbstractIteratorFilter<OlapTuple> membersLevelFilter;
        private OlapIterator<OlapMember> membersLevelIterator;
        final /* synthetic */ OlapSetComplementFunction this$0;

        public ComplementIterator(OlapSetComplementFunction this$0, IOlapEvaluationExceptionContext errContext, OlapMemberFilter memberFilter, OlapIterator<OlapTuple> operandAsSetIterator) {
            OlapSetComplementFunction olapSetComplementFunction = this$0;
            Objects.requireNonNull(olapSetComplementFunction);
            this.this$0 = olapSetComplementFunction;
            this.errContext = errContext;
            this.memberFilter = memberFilter;
            this.operandAsSetIterator = operandAsSetIterator;
        }

        @Override
        @Nullable
        public OlapTupleDimensionality getTupleDimensionality() {
            return this.operandAsSetIterator.getTupleDimensionality();
        }

        @Override
        public long fastEstimatedSize() {
            return this.newInstance()._sizeSlow();
        }

        @Override
        public boolean mightHaveCalcMember() {
            return false;
        }

        @Override
        public void reset() {
            this.operandAsSetIterator.reset();
            OlapTuple operandFirstTuple = this.operandAsSetIterator.next();
            if (operandFirstTuple == null) {
                this.this$0.onFunctionArgTypeMismatchError(this.errContext, 0, "set(member)", "{}");
                return;
            }
            if (operandFirstTuple.getMemberCount() != 1) {
                this.this$0.onFunctionArgTypeMismatchError(this.errContext, 0, "set(member)", "set(tuple)");
                return;
            }
            OlapLevel memberLevel = operandFirstTuple.getMember(0).getLevel();
            OlapTupleSet<OlapMember> membersLevel = memberLevel.getMembers(this.memberFilter);
            this.membersLevelFilter = new OlapTupleOlapAbstractIteratorFilter(this.errContext, operandFirstTuple, memberLevel, this.operandAsSetIterator);
            this.membersLevelIterator = membersLevel.getIterator(false);
        }

        @Override
        protected OlapTuple safeNext() {
            OlapMember member;
            while ((member = this.membersLevelIterator.next()) != null && !this.membersLevelFilter.accept(member)) {
            }
            return member;
        }

        @Override
        public OlapIterator<OlapTuple> newInstance() {
            return new ComplementIterator(this.this$0, this.errContext, this.memberFilter, this.operandAsSetIterator);
        }
    }

    private static class OlapTupleOlapAbstractIteratorFilter
    implements OlapAbstractIteratorFilter<OlapTuple> {
        final OlapLazyDistinctCollection<OlapTuple> operandAsCollection;
        private final IOlapEvaluationExceptionContext errContext;
        private final OlapTuple operandFirstTuple;
        private final OlapLevel memberLevel;
        private final OlapIterator<OlapTuple> operandAsSetIterator;

        public OlapTupleOlapAbstractIteratorFilter(final IOlapEvaluationExceptionContext errContext, OlapTuple operandFirstTuple, final OlapLevel memberLevel, OlapIterator<OlapTuple> operandAsSetIterator) {
            this.errContext = errContext;
            this.operandFirstTuple = operandFirstTuple;
            this.memberLevel = memberLevel;
            this.operandAsSetIterator = operandAsSetIterator;
            this.operandAsCollection = new OlapLazyDistinctCollection<OlapTuple>(this, operandAsSetIterator, operandFirstTuple){
                {
                    Objects.requireNonNull(this$0);
                    super(underlying, firstUnderlyingTuple);
                }

                @Override
                protected void addToDistincts(OlapTuple tuple) {
                    if (!tuple.getMember(0).getLevel().equals(memberLevel)) {
                        throw new OlapFunctionEvaluationException(errContext, OlapSetComplementFunction.NAME, OlapErrorCode.FUNCTION_EXPECT_MEMBERS_AT_SAME_LEVEL, new Serializable[]{ONames.uname4Log(memberLevel)});
                    }
                    super.addToDistincts(tuple);
                }
            };
        }

        @Override
        public boolean accept(OlapTuple tuple) {
            return !this.operandAsCollection.contains(tuple);
        }

        @Override
        public IOlapIteratorFilter<OlapTuple> newInstance() {
            return new OlapTupleOlapAbstractIteratorFilter(this.errContext, this.operandFirstTuple, this.memberLevel, this.operandAsSetIterator.newInstance());
        }
    }
}

