/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.OlapITuple;
import crazydev.iccube.collection.OlapITupleList;
import crazydev.iccube.collection.OlapITupleListMT;
import crazydev.iccube.collection.OlapITupleListST;
import crazydev.iccube.configuration.component.properties.OlapFilterProcessingMode;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.OlapIteratorApplyLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapNonEmptyApplyLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNonEmptyApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import crazydev.iccube.olap.eval.function.mdx.set.OlapGFIteratorFunctionUtils;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.util.concurrent.atomic.AtomicReference;

public class OlapNonEmptyFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "NonEmpty";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 3){

        @Override
        public boolean isLambda(int pos) {
            return pos == 1;
        }

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            if (pos == 2) {
                return OlapFunctionArgumentType.VALUE;
            }
            return super.getType(pos);
        }
    };

    public OlapNonEmptyFunction() {
        this(NAME);
    }

    public OlapNonEmptyFunction(String name) {
        super(name, ARGS);
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs) {
        if (OlapGFIteratorFunctionUtils.isLambdaWithoutLimit(context)) {
            return new OlapNonEmptyApplyLambdaPreparedInstr(callInstr, args, this, pArgs, Callback::new, -1);
        }
        int limitFromContext = OlapNonEmptyFunction.prepareLimit(context, callInstr);
        OlapProperties props = context.getRequestProperties();
        OlapFilterProcessingMode mode = props.getMdxEvalFilterProcessingMode();
        if (mode == OlapFilterProcessingMode.LAMBDA) {
            return new OlapNonEmptyApplyLambdaPreparedInstr(callInstr, args, this, pArgs, Callback::new, limitFromContext);
        }
        if (mode == OlapFilterProcessingMode.ITERATOR || mode == OlapFilterProcessingMode.ITERATOR_ST) {
            return new OlapIteratorApplyLambdaPreparedInstr(mode, Callback::new, true, callInstr, args, this, pArgs, limitFromContext);
        }
        throw new RuntimeException("internal error : unexpected NonEmpty() processing mode [" + String.valueOf((Object)mode) + "]");
    }

    private static class Callback
    extends GFApplyLambdaCallback<GFNonEmptyApplyLambdaNode> {
        private final AtomicReference<OlapITupleList> nonEmptyTuples;
        private boolean needsSorting;

        Callback(OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, int internalTupleListCount, int limit) {
            super(functionCallInstr, functionCallArgInstrs, function, "logical_expression");
            this.nonEmptyTuples = new AtomicReference<OlapITupleListST>(new OlapITupleListST(functionCallInstr.getLocationRange(), functionCallInstr.getFunctionName(), internalTupleListCount, limit));
        }

        @Override
        public OlapLambdaCallbackMode processingMode() {
            return OlapLambdaCallbackMode.PARALLEL;
        }

        @Override
        public void initX(GFContext context, boolean parallel, OlapTupleSet set, GFNonEmptyApplyLambdaNode lambdaArg, GFFunctionArgs args) {
            this.needsSorting = parallel;
            int limit = OlapNonScalarEntityFunction.actualLimitForInitX(context, args, this.nonEmptyTuples.get());
            if (args.size() == 3) {
                if (parallel) {
                    this.nonEmptyTuples.set(new OlapITupleListMT(lambdaArg.getLocationRange(), lambdaArg.getFunctionName(), context.getInternalTupleListCount(), limit));
                } else {
                    this.nonEmptyTuples.set(new OlapITupleListST(lambdaArg.getLocationRange(), lambdaArg.getFunctionName(), context.getInternalTupleListCount(), limit));
                }
            } else if (parallel) {
                this.nonEmptyTuples.set(new OlapITupleListMT(lambdaArg.getLocationRange(), lambdaArg.getFunctionName(), context.getInternalTupleListCount(), limit));
            }
        }

        @Override
        public int stopIterationOrdinal() {
            return this.nonEmptyTuples.get().stopIterationOrdinal();
        }

        @Override
        public void onScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapScalarEntity value1, OlapScalarEntity value2) {
            throw new RuntimeException("internal error: non-empty function w/ multi-scalar result");
        }

        @Override
        public void onNonScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapEntity value) {
            throw new RuntimeException("internal error: non-empty function w/ non-scalar result");
        }

        @Override
        public void onScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapScalarEntity value) {
            if (value.isMdxNull()) {
                throw new RuntimeException("internal error: non-empty function w/ empty result");
            }
            OlapITuple tuple = new OlapITuple(iTuple, iTupleOrdinal);
            this.nonEmptyTuples.get().add(tuple);
        }

        @Override
        public OlapEntity onDone(GFContext context) {
            return this.nonEmptyTuples.get().sort(this.needsSorting);
        }
    }
}

