/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import java.io.Serializable;

public class OlapNameToSetFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "NameToSet";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 0: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapNameToSetFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapEntity entity;
        String memberName = args.toMdxStringExpression(context, 0);
        if (memberName.trim().isEmpty()) {
            return (OlapNonScalarEntity)this.onFunctionError(args.getErrorContext(context, 0), OlapErrorCode.MDX_EXPRESSION_EXPECTED, new Serializable[0]);
        }
        try {
            entity = args.executeNameToSetMdxExpression(context, this, 0, memberName, "name-to-set-?");
        }
        catch (OlapException ex) {
            if (ex.isCausedBy(OlapErrorCode.UNKNOWN_DIMENSION_HIERARCHY) || ex.isCausedBy(OlapErrorCode.UNKNOWN_ENTITY)) {
                return OlapSetFactory.empty();
            }
            throw ex;
        }
        if (entity.isMdxNull()) {
            return OlapSetFactory.empty();
        }
        OlapTupleSet asSet = args.toNameSetIfApplicable(context, entity);
        if (asSet != null) {
            return asSet;
        }
        return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "member", entity.getFriendlyTypeName());
    }
}

