/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapAbstractIteratorFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import crazydev.iccube.olap.util.OlapExistHelper;
import org.jetbrains.annotations.Nullable;

public class OlapExistsFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "Exists";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 2){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapExistsFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapTupleSet<? extends OlapTuple> set1 = args.toSet(context, 0);
        OlapTupleSet<? extends OlapTuple> set2 = !args.isMissingArg(1) ? args.toSet(context, 1) : null;
        if (set2 == null) {
            OlapIterator<OlapTuple> iter = OlapIteratorFactory.filter(set1.getIterator(false), ExistsIteratorFilter.INSTANCE);
            return OlapSetFactory.instance(iter);
        }
        OlapTupleDimensionalityCache cache = args.getTupleDimensionalityCache(context);
        OlapTupleFilter memberTupleFilter = args.getMemberTupleFilter(context);
        ExistingOlapIteratorFilter filter = new ExistingOlapIteratorFilter(context, cache, memberTupleFilter, args.getTupleFilter(context), set2);
        OlapIterator<OlapTuple> filtered = OlapIteratorFactory.filter(set1.getIterator(false), filter);
        return OlapSetFactory.instance(filtered);
    }

    private static class ExistsIteratorFilter
    implements OlapAbstractIteratorFilter<OlapTuple> {
        public static ExistsIteratorFilter INSTANCE = new ExistsIteratorFilter();

        private ExistsIteratorFilter() {
        }

        @Override
        public boolean accept(OlapTuple o) {
            return o.exists(null);
        }

        @Override
        public IOlapIteratorFilter<OlapTuple> newInstance() {
            return this;
        }
    }

    private static class ExistingOlapIteratorFilter
    implements OlapAbstractIteratorFilter<OlapTuple> {
        private final IOlapEvaluationExceptionContext context;
        private final OlapTupleDimensionalityCache cache;
        @Nullable
        private final OlapTupleFilter memberTupleFilter;
        @Nullable
        private final OlapTupleFilter tupleFilter;
        private final OlapIterator<? extends OlapTuple> iter;

        public ExistingOlapIteratorFilter(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, @Nullable OlapTupleFilter memberTupleFilter, @Nullable OlapTupleFilter tupleFilter, OlapTupleSet<? extends OlapTuple> set2) {
            this.context = context;
            this.cache = cache;
            this.memberTupleFilter = memberTupleFilter;
            this.tupleFilter = tupleFilter;
            this.iter = set2.getIterator(true);
        }

        @Override
        public boolean accept(OlapTuple tuple) {
            OlapTuple tuple2;
            if (this.tupleFilter != null && !this.tupleFilter.isAccepting(tuple)) {
                return false;
            }
            this.iter.reset();
            while ((tuple2 = this.iter.next()) != null) {
                OlapTuple t;
                if (this.tupleFilter != null && !this.tupleFilter.isAccepting(tuple2) || this.memberTupleFilter != null && (t = OlapTupleFactory.instance(this.context, this.cache, this.memberTupleFilter, tuple, tuple2)).isKO() || !OlapExistHelper.forExistsFunction(tuple, tuple2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public IOlapIteratorFilter<OlapTuple> newInstance() {
            return this;
        }
    }
}

