/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;

public class OlapDrillUpMemberFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "DrillUpMember";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapDrillUpMemberFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapHierarchy set2Hierarchy;
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "set");
        if (arg0.isMdxNull()) {
            return OlapSetFactory.empty();
        }
        OlapTupleSet<? extends OlapTuple> set1 = args.toSet(context, 0);
        OlapEntity arg1 = args.getNonMissingArgEntity(context, 1, "set");
        if (arg1.isMdxNull()) {
            return set1;
        }
        OlapTupleSet<? extends OlapTuple> set2 = args.toSet(context, 1);
        OlapTuple member1 = (OlapTuple)set1.getIterator(false).next();
        if (member1 == null) {
            return set1;
        }
        OlapIterator iter2 = set2.getIterator(true);
        OlapTuple member2 = (OlapTuple)iter2.next();
        if (member2 == null) {
            return set1;
        }
        OlapTupleSet<OlapMember> setMember = set2.asMemberSet();
        if (setMember == null) {
            args.assertDimensionality(context, member1, member2);
            set2Hierarchy = null;
        } else {
            set2Hierarchy = member2.getTupleHierarchies().get(0);
        }
        OlapIterator<OlapTuple> iter = OlapIteratorFactory.filter(set1.getIterator(false), new DrillupFilter(set2Hierarchy, iter2));
        return OlapSetFactory.instance(iter);
    }

    private static class DrillupFilter
    implements IOlapIteratorFilter<OlapTuple> {
        private final OlapHierarchy set2Hierarchy;
        private final OlapIterator<? extends OlapTuple> iter2;
        private OlapTuple treeTuple = null;

        public DrillupFilter(OlapHierarchy set2Hierarchy, OlapIterator<? extends OlapTuple> iter2) {
            this.iter2 = iter2;
            this.set2Hierarchy = set2Hierarchy;
        }

        @Override
        public void reset() {
            this.treeTuple = null;
        }

        @Override
        public boolean accept(OlapTuple item1) {
            OlapTuple olapMember;
            if (this.treeTuple != null) {
                if (this.isAncestor(item1, this.treeTuple)) {
                    return false;
                }
                this.treeTuple = null;
            }
            this.iter2.reset();
            while ((olapMember = this.iter2.next()) != null) {
                if (!this.isRoot(item1, olapMember)) continue;
                this.treeTuple = olapMember;
                return true;
            }
            return true;
        }

        @Override
        public IOlapIteratorFilter<OlapTuple> newInstance() {
            return new DrillupFilter(this.set2Hierarchy, this.iter2.newInstance());
        }

        private boolean isRoot(OlapTuple item1, OlapTuple item2) {
            if (this.set2Hierarchy != null) {
                OlapMember member1 = item1.getMember(this.set2Hierarchy);
                return item2.equals(member1);
            }
            return item1.equals(item2);
        }

        private boolean isAncestor(OlapTuple item1, OlapTuple item2) {
            if (this.set2Hierarchy != null) {
                OlapMember member1 = item1.getMember(this.set2Hierarchy);
                return ((OlapMember)item2).isAncestor(member1);
            }
            for (int i = 0; i < item1.getMemberCount(); ++i) {
                OlapMember member1 = item1.getMember(i);
                OlapMember member2 = item2.getMember(i);
                if (member2.isAncestor(member1)) continue;
                return false;
            }
            return true;
        }
    }
}

