/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapAbstractIteratorFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import org.jetbrains.annotations.Nullable;

public class OlapDrillUpLevelFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "DrillUpLevel";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 2){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapDrillUpLevelFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapLevel argLevel;
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "set");
        if (arg0.isMdxNull()) {
            return OlapSetFactory.empty();
        }
        OlapTupleSet<? extends OlapTuple> set1 = args.toSet(context, 0);
        if (args.isMissingArg(1)) {
            OlapLevel lowestLevel = this.getLowestLevel(set1);
            if (lowestLevel == null) {
                return set1;
            }
            argLevel = lowestLevel.getPreviousLevel();
            if (argLevel == null) {
                return set1;
            }
        } else {
            argLevel = args.toLevel(context, 1);
        }
        OlapIterator<OlapTuple> iter = OlapIteratorFactory.filter(set1.getIterator(false), new OlapDrillupLevelIteratorFilter(argLevel));
        return OlapSetFactory.instance(iter);
    }

    @Nullable
    protected OlapLevel getLowestLevel(OlapTupleSet<? extends OlapTuple> set) {
        OlapTuple tuple;
        OlapLevel lowestLevel = null;
        OlapIterator tuples = set.getIterator(false);
        tuples.reset();
        while ((tuple = (OlapTuple)tuples.next()) != null) {
            OlapMember member = tuple.getMember(0);
            if (lowestLevel != null && member.getLevel().getDepth() <= lowestLevel.getDepth()) continue;
            lowestLevel = member.getLevel();
        }
        return lowestLevel;
    }

    private static class OlapDrillupLevelIteratorFilter
    implements OlapAbstractIteratorFilter<OlapTuple> {
        private final OlapHierarchy set2Hierarchy;
        private final int levelDepth;

        public OlapDrillupLevelIteratorFilter(OlapLevel argLevel) {
            this.levelDepth = argLevel.getDepth();
            this.set2Hierarchy = argLevel.getHierarchy();
        }

        @Override
        public boolean accept(OlapTuple item) {
            OlapMember oMember = item.getMember(this.set2Hierarchy);
            if (oMember == null) {
                return true;
            }
            return oMember.getLevel().getDepth() <= this.levelDepth;
        }

        @Override
        public IOlapIteratorFilter<OlapTuple> newInstance() {
            return this;
        }
    }
}

