/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import java.io.Serializable;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class OlapDescendantsFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "Descendants";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 3){

        @Override
        public boolean isOption(int pos) {
            return pos == 2;
        }

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapDescendantsFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "member");
        if (arg0.isMdxNull()) {
            return OlapSetFactory.empty();
        }
        OlapMember member = args.toMemberIfApplicable(context, 0);
        if (member != null) {
            OlapParams params = this.toParamsForCluster(context, args);
            return this.doEvalForMemberForCluster(context, args, member, params);
        }
        OlapTupleSet<? extends OlapTuple> set = args.toSet(context, 0);
        return this.doEvalForSetForCluster(context, args, 0, set);
    }

    private OlapTupleSet<OlapMember> doEvalForMemberForCluster(GFContext context, GFFunctionArgs args, OlapMember member, OlapParams params) {
        if (params.distance == -1) {
            if (params.level != null && member.getHierarchy() != params.level.getHierarchy()) {
                return (OlapTupleSet)args.onFunctionError(context, OlapErrorCode.DESCENDANTS_INVALID_LEVEL, new Serializable[]{params.level.getUniqueName(args.getNameContext(context)), member.getUniqueName(args.getNameContext(context))});
            }
            return member.getDescendants(args.getMemberFilter(context), params.level, params.descFlag);
        }
        return member.getDescendants(args.getMemberFilter(context), params.distance, params.descFlag);
    }

    private OlapTupleSet<?> doEvalForSetForCluster(GFContext context, GFFunctionArgs args, int setArgNb, OlapTupleSet<? extends OlapTuple> set) {
        OlapTuple member;
        OlapParams params = this.toParamsForCluster(context, args);
        ArrayList allFilteredDescendants = new ArrayList();
        OlapIterator members = set.getIterator(false);
        members.reset();
        while ((member = (OlapTuple)members.next()) != null) {
            if (member.getMemberCount() != 1) {
                return (OlapTupleSet)args.onFunctionArgTypeMismatchError(context, setArgNb, "set(member)", member.getFriendlyTypeName());
            }
            OlapTupleSet<OlapMember> filteredDescendants = this.doEvalForMemberForCluster(context, args, member.getMember(0), params);
            allFilteredDescendants.add(filteredDescendants);
        }
        OlapIterator union = OlapIteratorFactory.union(allFilteredDescendants, true);
        return OlapSetFactory.instance(union);
    }

    private OlapParams toParamsForCluster(GFContext context, GFFunctionArgs args) {
        OlapLevel level = null;
        int distance = -1;
        OlapOption descFlag = OlapOption.SELF_BEFORE_AFTER;
        if (!args.isMissingArg(1)) {
            OlapEntity arg1 = args.getNonMissingArgEntity(context, 1, "numeric|level");
            if (arg1 instanceof OlapLevel) {
                level = (OlapLevel)arg1;
            } else {
                distance = args.toInteger(context, 1);
            }
            descFlag = OlapOption.SELF;
        }
        if (!args.isMissingArg(2)) {
            descFlag = this.toOptionForCluster(context, args, 2);
        }
        return new OlapParams(level, distance, descFlag);
    }

    private OlapOption toOptionForCluster(GFContext context, GFFunctionArgs args, int argNb) {
        OlapOption descFlag = args.toOption(context, argNb, OlapOption.SELF, OlapOption.AFTER, OlapOption.BEFORE, OlapOption.BEFORE_AND_AFTER, OlapOption.SELF_AND_AFTER, OlapOption.SELF_AND_BEFORE, OlapOption.SELF_BEFORE_AFTER, OlapOption.LEAVES);
        return descFlag;
    }

    private static class OlapParams {
        @Nullable
        private final OlapLevel level;
        private final int distance;
        private final OlapOption descFlag;

        private OlapParams(@Nullable OlapLevel level, int distance, OlapOption descFlag) {
            this.level = level;
            this.distance = distance;
            this.descFlag = descFlag;
        }
    }
}

