/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.set;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapAllMembersFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "AllMembers";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapAllMembersFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "level|hierarchy|dimension");
        if (arg0 instanceof OlapLevel) {
            return OlapAllMembersFunction.doEvalForLevelForCluster(context, args, (OlapLevel)arg0);
        }
        if (arg0 instanceof OlapHierarchy) {
            return OlapAllMembersFunction.doEvalForHierarchyForCluster(context, args, (OlapHierarchy)arg0);
        }
        if (arg0 instanceof OlapDimension) {
            OlapHierarchy hierarchy = args.toOnlyHierarchy(context, 0, (OlapDimension)arg0);
            return OlapAllMembersFunction.doEvalForHierarchyForCluster(context, args, hierarchy);
        }
        return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "level|hierarchy|dimension", arg0.getFriendlyTypeName());
    }

    public static OlapNonScalarEntity doEvalForLevelForCluster(GFContext context, GFFunctionArgs args, OlapLevel level) {
        ArrayList<OlapMember> levelCalcMembers = new ArrayList<OlapMember>();
        for (OlapMember calcMember : args.getAllCalculatedMembers(context)) {
            if (!calcMember.getLevel().equals(level)) continue;
            levelCalcMembers.add(calcMember);
        }
        OlapTupleSet<OlapMember> levelMembers = OlapAllMembersFunction.withUserDefinedMeasures(context, args, level.getHierarchy(), level.getMembers(args.getMemberFilter(context)));
        if (levelCalcMembers.isEmpty()) {
            return levelMembers;
        }
        return OlapAllMembersFunction.createAllMembersIterator(levelCalcMembers, levelMembers);
    }

    public static OlapNonScalarEntity doEvalForHierarchyForCluster(GFContext context, GFFunctionArgs args, OlapHierarchy hierarchy) {
        ArrayList<OlapMember> hierarchyCalcMembers = new ArrayList<OlapMember>();
        for (OlapMember calcMember : args.getAllCalculatedMembers(context)) {
            if (!calcMember.getHierarchy().equals(hierarchy)) continue;
            hierarchyCalcMembers.add(calcMember);
        }
        OlapTupleSet<OlapMember> hierarchyMembers = OlapAllMembersFunction.withUserDefinedMeasures(context, args, hierarchy, hierarchy.getMembers(args.getMemberFilter(context)));
        if (hierarchyCalcMembers.isEmpty()) {
            return hierarchyMembers;
        }
        return OlapAllMembersFunction.createAllMembersIterator(hierarchyCalcMembers, hierarchyMembers);
    }

    private static OlapTupleSet<OlapMember> withUserDefinedMeasures(GFContext context, GFFunctionArgs args, OlapHierarchy hierarchy, OlapTupleSet<OlapMember> members) {
        OlapMember regularMeasure;
        if (!hierarchy.isMeasures()) {
            return members;
        }
        OlapMemberFilter memberFilter = args.getMemberFilter(context);
        List<OlapUserMeasureMember> userDefinedMeasures = context.lookupUserDefinedMeasures(memberFilter);
        if (userDefinedMeasures.isEmpty()) {
            return members;
        }
        ArrayList<OlapMember> allMeasures = new ArrayList<OlapMember>();
        OlapIterator regularMeasures = members.getIterator(false);
        regularMeasures.reset();
        while ((regularMeasure = (OlapMember)regularMeasures.next()) != null) {
            allMeasures.add(regularMeasure);
        }
        allMeasures.addAll(userDefinedMeasures);
        return OlapSetFactory.instance(allMeasures);
    }

    private static OlapNonScalarEntity createAllMembersIterator(List<OlapMember> calcMembers, OlapTupleSet<OlapMember> members) {
        Collections.sort(calcMembers, OlapMember.RANK_COMPARATOR);
        AllMembersIterator allMembers = new AllMembersIterator(members, calcMembers);
        return OlapSetFactory.instance(allMembers);
    }

    static class AllMembersIterator
    extends OlapBaseIterator<OlapMember> {
        private final OlapTupleSet<OlapMember> regularMembers;
        private final List<OlapMember> rankedCalcMembers;
        private final OlapIterator<OlapMember> members;
        private final List<OlapMember> notReturnedCalcMembers;
        private OlapMember member;

        AllMembersIterator(OlapTupleSet<OlapMember> regularMembers, List<OlapMember> rankedCalcMembers) {
            this.regularMembers = regularMembers;
            this.rankedCalcMembers = rankedCalcMembers;
            this.members = regularMembers.getIterator(false);
            this.notReturnedCalcMembers = new ArrayList<OlapMember>();
        }

        @Override
        @Nullable
        public OlapTupleDimensionality getTupleDimensionality() {
            return this.members.getTupleDimensionality();
        }

        @Override
        public long fastEstimatedSize() {
            long size = this.regularMembers.fastEstimatedSize();
            if (size == -1L) {
                return -1L;
            }
            return size += (long)this.rankedCalcMembers.size();
        }

        @Override
        public boolean mightHaveCalcMember() {
            if (this.rankedCalcMembers.isEmpty()) {
                return this.regularMembers.mightHaveCalcMember();
            }
            return !this.rankedCalcMembers.isEmpty();
        }

        @Override
        public boolean isMemberIterator() {
            return true;
        }

        @Override
        public boolean isMembersCrossjoin() {
            return true;
        }

        @Override
        public void reset() {
            this.member = null;
            this.members.reset();
            this.notReturnedCalcMembers.clear();
            this.notReturnedCalcMembers.addAll(this.rankedCalcMembers);
        }

        @Override
        @Nullable
        protected OlapMember safeNext() {
            OlapMember nextCalcMember;
            if (this.member == null) {
                this.member = this.members.next();
            }
            if (this.member == null) {
                if (!this.notReturnedCalcMembers.isEmpty()) {
                    return this.notReturnedCalcMembers.remove(0);
                }
                return null;
            }
            if (!this.notReturnedCalcMembers.isEmpty() && (nextCalcMember = this.notReturnedCalcMembers.get(0)).getRank().compareTo(this.member.getRank()) < 0) {
                return this.notReturnedCalcMembers.remove(0);
            }
            OlapMember nextMember = this.member;
            this.member = null;
            return nextMember;
        }

        public AllMembersIterator newInstance() {
            return new AllMembersIterator(this.regularMembers, this.rankedCalcMembers);
        }
    }
}

