/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.others;

import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapPatternStringEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapMultiArgFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.literal.OlapPatternLiteralInstr;
import crazydev.iccube.olap.eval.literal.OlapStringLiteralInstr;
import crazydev.iccube.olap.eval.option.OlapOptionInstr;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public abstract class OlapAbstractPatternMatchesFunction
extends OlapScalarEntityFunction {
    protected OlapAbstractPatternMatchesFunction(String name, OlapFunctionArgs argsInfo) {
        super(name, argsInfo);
    }

    @Override
    @Nullable
    public OlapInstr asInstr(OlapCompilationContext context, OlapInstrLocationRange location, OlapFunctionCallInstr.Notation mdxNotation, OlapInstr[] args) {
        try {
            if (args.length > 0 && args[0] instanceof OlapStringLiteralInstr) {
                String pattern = ((OlapStringLiteralInstr)args[0]).getValue().value();
                String patternQ = this.quoteRawPattern(pattern);
                OlapOption option = null;
                if (args.length > 2 && args[2] instanceof OlapOptionInstr && !(option = ((OlapOptionInstr)args[2]).getOption()).equals(OlapOption.CASE_INSENSITIVE) && !option.equals(OlapOption.CASE_SENSITIVE)) {
                    throw new RuntimeException("invalid option [" + String.valueOf(option) + "]");
                }
                String patternX = this.completeQuotedPattern(option, patternQ);
                Pattern regexp = Pattern.compile(patternX);
                OlapPatternLiteralInstr regexpI = new OlapPatternLiteralInstr(args[0].getLocationRange(), regexp);
                OlapInstr[] argsN = new OlapInstr[]{regexpI, args[1]};
                return new OlapMultiArgFunctionCallInstr(location, mdxNotation, this, argsN);
            }
        }
        catch (RuntimeException ignored) {
            OlapLoggers.MDX_EVALUATION.warn((Object)("[mdx] could not optimize " + this.getName() + "()"), (Throwable)ignored);
        }
        return super.asInstr(context, location, mdxNotation, args);
    }

    protected String quoteRawPattern(String pattern) {
        return Pattern.quote(pattern);
    }

    protected String completeQuotedPattern(@Nullable OlapOption option, String quotedPattern) {
        if (option == OlapOption.CASE_INSENSITIVE) {
            return "(?i)" + this.wrapQuotedPattern(quotedPattern);
        }
        return this.wrapQuotedPattern(quotedPattern);
    }

    protected abstract String wrapQuotedPattern(String var1);

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "string");
        if (arg0.isMdxNull()) {
            return OlapAbstractPatternMatchesFunction.asEmpty();
        }
        if (arg0 instanceof OlapPatternStringEntity) {
            return this.evalForClusterP(context, args, ((OlapPatternStringEntity)arg0).getPattern());
        }
        String pattern = args.toString(context, 0);
        String value = args.toString(context, 1, true);
        if (value == null) {
            return OlapAbstractPatternMatchesFunction.asEmpty();
        }
        OlapOption option = args.toOptionalOption(context, 2, OlapOption.CASE_SENSITIVE, OlapOption.CASE_INSENSITIVE);
        String patternQ = this.quoteRawPattern(pattern);
        String patternX = this.completeQuotedPattern(option, patternQ);
        boolean matches = value.matches(patternX);
        return OlapBooleanEntity.value(matches);
    }

    protected OlapScalarEntity evalForClusterP(GFContext context, GFFunctionArgs args, Pattern regexp) {
        String value = args.toString(context, 1, true);
        if (value == null) {
            return OlapAbstractPatternMatchesFunction.asEmpty();
        }
        boolean matches = regexp.matcher(value).matches();
        return OlapBooleanEntity.value(matches);
    }
}

