/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.numeric.calculators;

import crazydev.iccube.plugin.function.OlapSetCalculatorTwoExpression;

public abstract class OlapCovarianceSinglePassCalculator
implements OlapSetCalculatorTwoExpression {
    protected double sum_sq_x = 0.0;
    protected double sum_sq_y = 0.0;
    protected double sum_coproduct = 0.0;
    protected double mean_x = 0.0;
    protected double mean_y = 0.0;
    protected int count = 0;

    public static OlapCovarianceSinglePassCalculator create() {
        return new OlapCovarianceSinglePassCalculator(){

            @Override
            public double calculate() {
                return 0.0;
            }
        };
    }

    @Override
    public boolean isResultEmpty() {
        return this.count == 0;
    }

    @Override
    public void addValue(double valueX, double valueY) {
        if (this.count == 0) {
            ++this.count;
            this.mean_x = valueX;
            this.mean_y = valueY;
        } else {
            ++this.count;
            double sweep = ((double)this.count - 1.0) / (double)this.count;
            double delta_x = valueX - this.mean_x;
            double delta_y = valueY - this.mean_y;
            this.sum_sq_x += delta_x * delta_x * sweep;
            this.sum_sq_y += delta_y * delta_y * sweep;
            this.sum_coproduct += delta_x * delta_y * sweep;
            this.mean_x += delta_x / (double)this.count;
            this.mean_y += delta_y / (double)this.count;
        }
    }

    public double getMean_x() {
        return this.mean_x;
    }

    public double getMean_y() {
        return this.mean_y;
    }

    protected double calculateCorrelation() {
        double cov_x_y = this.sum_coproduct / (double)this.count;
        double pop_sd_y = StrictMath.sqrt(this.sum_sq_y / (double)this.count);
        double pop_sd_x = StrictMath.sqrt(this.sum_sq_x / (double)this.count);
        return cov_x_y == 0.0 ? 0.0 : cov_x_y / (pop_sd_x * pop_sd_y);
    }

    protected double calculateCovarianceN() {
        return this.sum_coproduct / (double)this.count;
    }

    protected double calculateCovarianceN_1() {
        if (this.count <= 1) {
            return 0.0;
        }
        return this.sum_coproduct / (double)(this.count - 1);
    }
}

