/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.numeric;

import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseGenericStatisticalFunction;
import crazydev.iccube.olap.eval.function.mdx.numeric.calculators.OlapSetCalculatorOneGenExpression;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import java.util.Objects;

public class OlapMinFunction
extends OlapBaseGenericStatisticalFunction {
    public static final String NAME = "Min";

    public OlapMinFunction() {
        super(NAME);
    }

    @Override
    protected OlapSetCalculatorOneGenExpression createCalculator(GFFunctionArgs args, OlapTupleSet set) {
        return new OlapSetCalculatorOneGenExpression(this){
            OlapScalarEntity minValue;
            {
                Objects.requireNonNull(this$0);
                this.minValue = null;
            }

            @Override
            public int stopIterationOrdinal() {
                return -1;
            }

            @Override
            public void addNull(OlapTuple setTuple, int iTupleOrdinal) {
            }

            @Override
            public void addValue(GFContext context, OlapTuple setTuple, int iTupleOrdinal, OlapScalarEntity value) {
                if (this.minValue == null) {
                    this.minValue = value;
                } else {
                    int comp = OlapScalarOperators.compare(context.getSchema().getLocalizedStringComparator(), value, this.minValue);
                    if (comp < 0) {
                        this.minValue = value;
                    }
                }
            }

            @Override
            public boolean isResultEmpty() {
                return this.minValue == null;
            }

            @Override
            public OlapScalarEntity calculate() {
                return this.minValue;
            }
        };
    }
}

