/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.numeric;

import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseNumericStatisticalFunction;
import crazydev.iccube.plugin.function.OlapSetCalculatorOneExpression;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import java.util.Objects;

public class OlapMedianFunction
extends OlapBaseNumericStatisticalFunction {
    public static final String NAME = "Median";

    public OlapMedianFunction() {
        super(NAME);
    }

    @Override
    protected OlapSetCalculatorOneExpression createCalculator(final GFContext context, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args) {
        return new OlapSetCalculatorOneExpression(){
            private final DoubleArrayList values;
            {
                Objects.requireNonNull(this$0);
                this.values = new DoubleArrayList();
            }

            @Override
            public void addValue(double value) {
                context.assertNotCancelling("median");
                this.values.add(value);
            }

            @Override
            public boolean isResultEmpty() {
                return this.values.isEmpty();
            }

            @Override
            public double calculate() {
                this.values.sort(DoubleComparators.NATURAL_COMPARATOR);
                int half = this.values.size() / 2;
                double median = this.values.size() % 2 == 0 ? (this.values.getDouble(half) + this.values.getDouble(half - 1)) / 2.0 : this.values.getDouble(half);
                return median;
            }
        };
    }
}

