/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.numeric;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.OlapGenericLinRegPointApplyLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseStatisticalTwoExprFunction;
import crazydev.iccube.olap.eval.function.mdx.numeric.calculators.IOlapLinearRegressionSinglePassCalculator;
import crazydev.iccube.olap.eval.function.mdx.numeric.calculators.OlapLinearRegressionSinglePassCalculator;
import crazydev.iccube.olap.eval.function.mdx.numeric.calculators.OlapLinearRegressionSinglePassCalculatorMT;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.plugin.function.OlapSetCalculatorTwoExpression;
import java.util.Objects;

public class OlapLinRegPointFunction
extends OlapBaseStatisticalTwoExprFunction {
    public static final String NAME = "LinRegPoint";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(3, 4){

        @Override
        public boolean isLambda(int pos) {
            return pos == 2 || pos == 3;
        }
    };

    public OlapLinRegPointFunction() {
        super(NAME, ARGS);
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs) {
        return new OlapGenericLinRegPointApplyLambdaPreparedInstr(callInstr, args, (OlapFunction)this, pArgs, (x$0, x$1, x$2, x$3, x$4) -> new Callback(this, x$0, x$1, x$2, x$3, x$4));
    }

    @Override
    protected OlapSetCalculatorTwoExpression createCalculator() {
        throw new CdDoNotCallMeProgrammingException();
    }

    class Callback
    extends GFApplyLambdaCallback<GFGenericApplyLambdaNode> {
        private volatile IOlapLinearRegressionSinglePassCalculator calculator;
        private volatile double slice;
        final /* synthetic */ OlapLinRegPointFunction this$0;

        Callback(OlapLinRegPointFunction this$0, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, int internalTupleListCount, int limit) {
            OlapLinRegPointFunction olapLinRegPointFunction = this$0;
            Objects.requireNonNull(olapLinRegPointFunction);
            this.this$0 = olapLinRegPointFunction;
            super(functionCallInstr, functionCallArgInstrs, function, "numeric_expression");
        }

        @Override
        public OlapLambdaCallbackMode processingMode() {
            return this.this$0.getProcessingMode();
        }

        @Override
        public void init(GFContext context, OlapTupleSet set, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args) {
            this.calculator = OlapLinearRegressionSinglePassCalculator.create();
            this.slice = args.toNumeric(context, 0).doubleValue();
        }

        @Override
        public void initX(GFContext context, boolean parallel, OlapTupleSet set, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args) {
            if (parallel && this.calculator != null) {
                this.calculator = new OlapLinearRegressionSinglePassCalculatorMT(this.calculator);
            }
        }

        @Override
        public void onScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapScalarEntity value1, OlapScalarEntity value2) {
            if (this.calculator != null && !value1.isMdxNull() && !value2.isMdxNull()) {
                if (value1 instanceof OlapNumericEntity && value2 instanceof OlapNumericEntity) {
                    OlapNumericEntity y = (OlapNumericEntity)value1;
                    OlapNumericEntity x = (OlapNumericEntity)value2;
                    this.calculator.addValue(x.doubleValue(), y.doubleValue());
                } else if (!(value1 instanceof OlapNumericEntity)) {
                    this.onFunctionArgTypeMismatchError(context, 1, "numeric", value1.getFriendlyTypeName());
                } else {
                    this.onFunctionArgTypeMismatchError(context, 2, "numeric", value1.getFriendlyTypeName());
                }
            }
        }

        @Override
        public OlapEntity onDone(GFContext context) {
            if (this.calculator == null || this.calculator.isResultEmpty()) {
                return OlapLinRegPointFunction.asEmpty();
            }
            double a = this.calculator.calculateA();
            double b = this.calculator.calculateB();
            return new OlapNumericEntity(a + b * this.slice, true);
        }
    }
}

