/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.numeric;

import crazydev.common.collection.CdSingleItemList;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeNeutralEntity;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeUnionEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapMemberOrigin;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.GFTupleEvaluationFrame;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFEvalTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class OlapEvalFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "Eval";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2){

        @Override
        public boolean isLambda(int pos) {
            return pos == 1;
        }

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            return pos == 0 ? OlapFunctionArgumentType.SUBCUBE : OlapFunctionArgumentType.ANY;
        }
    };

    public OlapEvalFunction() {
        super(NAME, ARGS);
    }

    @Override
    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context, GFNode[] args) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehavior.one();
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        return (OlapScalarEntity)OlapEvalFunction.evalForCluster(this.getName(), context, args, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OlapEntity evalForCluster(String name, GFContext context, GFFunctionArgs args, boolean forScalar) {
        OlapSubCubeEntity entity;
        OlapTupleDimensionality tupleDim;
        OlapTupleSet<? extends OlapTuple> set = args.toSetIfApplicable(context, 0);
        if (set != null) {
            tupleDim = set.getTupleDimensionality();
            entity = OlapEvalFunction.asSubCube(context, set);
        } else {
            tupleDim = null;
            entity = args.toSubCube(context, 0, "SubCube|Set");
        }
        S_RequestSubCubeDef reqSubCube = args.getOrCreateFactsSubCube(context, entity);
        args.pushFactsSubCube(context, reqSubCube);
        List<GFTupleEvaluationFrame> frames = tupleDim == null ? null : OlapEvalFunction.addDefaultsToContext(context, tupleDim);
        try {
            if (forScalar) {
                OlapScalarEntity olapScalarEntity = OlapEvalFunction.evalForScalar(name, context, args);
                return olapScalarEntity;
            }
            OlapEntity olapEntity = OlapEvalFunction.evalForEntity(context, args);
            return olapEntity;
        }
        finally {
            if (frames != null) {
                frames.forEach(context::popEvaluatedTuple);
            }
            args.popFactsSubCube(context, reqSubCube);
        }
    }

    private static OlapScalarEntity evalForScalar(String name, GFContext context, GFFunctionArgs args) {
        OlapScalarEntity value;
        GFEvalTupleEvaluator evaluator = new GFEvalTupleEvaluator();
        GFMiniTupleEvaluator miniEvaluator = new GFMiniTupleEvaluator(null, evaluator);
        miniEvaluator.onRootCalcMemberEvalStarted(context);
        OlapEntity arg = args.getNonMissingArgEntity(context, 1, "scalar");
        if (arg.isMdxNull()) {
            value = OlapEvalFunction.asEmpty();
        } else {
            if (!arg.isToValueApplicable(context, miniEvaluator)) {
                return (OlapScalarEntity)OlapEvalFunction.onFunctionArgTypeMismatchErrorS(name, context, 1, "scalar", arg.getFriendlyTypeName());
            }
            value = context.toValue(miniEvaluator, arg);
        }
        miniEvaluator.onRootCalcMemberEvalCompleted(context);
        return value;
    }

    private static OlapEntity evalForEntity(GFContext context, GFFunctionArgs args) {
        OlapEntity arg = args.getNonMissingArgEntity(context, 1, "entity");
        if (arg.isMdxNull()) {
            return OlapEvalFunction.asNull();
        }
        return arg;
    }

    private static List<GFTupleEvaluationFrame> addDefaultsToContext(GFContext context, OlapTupleDimensionality tupleDim) {
        List origins = CdSingleItemList.asList((Object)((Object)OlapMemberOrigin.OTHER));
        return context.getSchema().getHierarchies(tupleDim).stream().map(h -> h.getNullableDefaultMember(context.getMemberFilter())).filter(Objects::nonNull).map(m -> context.pushEvaluatedTuple(origins, (OlapTuple)m)).collect(Collectors.toList());
    }

    private static OlapSubCubeEntity asSubCube(GFContext context, OlapTupleSet<? extends OlapTuple> set) {
        OlapTuple tuple;
        if (set.isNeutralElement()) {
            return new OlapSubCubeNeutralEntity(context.getErrorLocation());
        }
        OlapIterator iter = set.getIterator(false);
        ArrayList<OlapNonScalarEntity> list = new ArrayList<OlapNonScalarEntity>();
        iter.reset();
        while ((tuple = (OlapTuple)iter.next()) != null) {
            list.add(tuple);
        }
        return new OlapSubCubeUnionEntity(list);
    }
}

