/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.numeric;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.OlapGenericApplyLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapOptionPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapCountDimensionsFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapCountLevelsFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public class OlapCountFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "Count";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 2){

        @Override
        public boolean isOption(int pos) {
            return pos == 1;
        }

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapCountFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapInstr asInstr(OlapCompilationContext context, OlapInstrLocationRange location, OlapFunctionCallInstr.Notation mdxNotation, OlapInstr[] args) {
        OlapInstr arg0;
        if (args.length == 1 && (arg0 = args[0]) instanceof OlapFunctionCallInstr) {
            OlapFunctionCallInstr fCall = (OlapFunctionCallInstr)arg0;
            String fName = fCall.getFunctionName();
            if (fName.equalsIgnoreCase("Dimensions")) {
                if (fCall.getArgCount() != 0) {
                    return (OlapInstr)this.onFunctionCompilationArgumentCountError(context, fName, fCall.getArgCount(), "0");
                }
                return new OlapCountDimensionsFunctionCallInstr(location, mdxNotation, this);
            }
            if (fName.equalsIgnoreCase("Levels")) {
                if (fCall.getArgCount() != 1) {
                    return (OlapInstr)this.onFunctionCompilationArgumentCountError(context, fName, fCall.getArgCount(), "1");
                }
                OlapInstr hierarchy = fCall.getArg(0);
                hierarchy.detachFromParent();
                return new OlapCountLevelsFunctionCallInstr(location, mdxNotation, this, hierarchy);
            }
        }
        return null;
    }

    private static OlapNumericEntity asCount(int count) {
        return new OlapNumericEntity(count, true);
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs) {
        OlapOption option;
        OlapPreparedInstr pArg;
        if (pArgs.length > 1 && (pArg = pArgs[1]) instanceof OlapOptionPreparedInstr && OlapOption.EXCLUDEEMPTY == (option = ((OlapOptionPreparedInstr)pArg).getOption())) {
            OlapInstr[] args_ = new OlapInstr[]{args[0]};
            OlapPreparedInstr[] pArgs_ = new OlapPreparedInstr[]{pArgs[0]};
            return new OlapGenericApplyLambdaPreparedInstr(callInstr, args_, this, pArgs_, Callback::new, -1);
        }
        return super.doPrepareFunctionCall(context, callInstr, args, pArgs);
    }

    public OlapEntity evalForClusterForDimensions(GFContext context, GFFunctionArgs args) {
        return OlapCountFunction.asCount(args.getHierarchyCount(context));
    }

    public OlapEntity evalForClusterForLevels(GFContext context, GFFunctionArgs args) {
        OlapEntity entity = args.getNonMissingArgEntity(context, 0, "dimension|hierarchy");
        if (entity instanceof OlapDimension) {
            OlapDimension dimension = (OlapDimension)entity;
            int hierarchyCount = dimension.getHierarchyCount(args.getDimensionsPermissions(context));
            if (hierarchyCount == 0) {
                OlapNameContext nameContext = args.getNameContext(context);
                return (OlapEntity)args.onFunctionError(context, OlapErrorCode.FUNCTION_DIMENSION_WITH_NO_HIERARCHY, new Serializable[]{dimension.getUniqueName(nameContext)});
            }
            if (hierarchyCount > 1) {
                OlapNameContext nameContext = args.getNameContext(context);
                return (OlapEntity)args.onFunctionError(context, OlapErrorCode.FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY, new Serializable[]{dimension.getUniqueName(nameContext)});
            }
            IOlapDimensionsPermission dimensionsPermission = args.getDimensionsPermissions(context);
            OlapHierarchy hierarchy = dimension.getSingleHierarchy(dimensionsPermission);
            IOlapHierarchyPermission hierarchyPermissions = args.getHierarchyPermissions(context, hierarchy);
            return OlapCountFunction.asCount(hierarchy.getLevels(hierarchyPermissions).size());
        }
        if (entity instanceof OlapHierarchy) {
            OlapHierarchy hierarchy = (OlapHierarchy)entity;
            IOlapHierarchyPermission hierarchyPermissions = args.getHierarchyPermissions(context, hierarchy);
            return OlapCountFunction.asCount(hierarchy.getLevels(hierarchyPermissions).size());
        }
        return (OlapEntity)args.onFunctionArgTypeMismatchError(context, 0, "levels", entity.getFriendlyTypeName());
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapOption option;
        if (!args.isMissingArg(1) && OlapOption.INCLUDEEMPTY != (option = args.toOption(context, 1, OlapOption.EXCLUDEEMPTY, OlapOption.INCLUDEEMPTY))) {
            return (OlapScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "EXCLUDEEMPTY-INCLUDEEMPTY", option.getFriendlyTypeName());
        }
        OlapTuple tuple = args.toTupleOptionalIfApplicable(context, 0);
        if (tuple != null) {
            if (tuple.exists(context.getMemberTupleFilter())) {
                return OlapCountFunction.asCount(tuple.getMemberCount());
            }
            return OlapCountFunction.asCount(0);
        }
        OlapTupleSet<? extends OlapTuple> set = args.toSet(context, 0);
        return OlapCountFunction.asCount(set._sizeSlow());
    }

    static class Callback
    extends GFApplyLambdaCallback<GFGenericApplyLambdaNode> {
        private final AtomicInteger count = new AtomicInteger();

        Callback(OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, int internalTupleListCount, int limit) {
            super(functionCallInstr, functionCallArgInstrs, function, "set_expression");
        }

        @Override
        public OlapLambdaCallbackMode processingMode() {
            return OlapLambdaCallbackMode.PARALLEL;
        }

        @Override
        public void init(GFContext context, OlapTupleSet set, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args) {
            this.count.set(0);
        }

        @Override
        public void onScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapScalarEntity value) {
            this.count.incrementAndGet();
        }

        @Override
        public OlapEntity onDone(GFContext context) {
            return OlapCountFunction.asCount(this.count.intValue());
        }
    }
}

