/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.numeric;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.OlapGenericTwoExprApplyLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import crazydev.iccube.plugin.function.OlapSetCalculatorTwoExpression;
import crazydev.iccube.plugin.function.OlapSetCalculatorTwoExpressionMT;
import java.util.Objects;

public abstract class OlapBaseStatisticalTwoExprFunction
extends OlapScalarEntityFunction {
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3){

        @Override
        public boolean isLambda(int pos) {
            return pos == 1 || pos == 2;
        }
    };

    public OlapBaseStatisticalTwoExprFunction(String name, OlapFunctionArgs arguments) {
        super(name, arguments);
    }

    protected OlapLambdaCallbackMode getProcessingMode() {
        return OlapLambdaCallbackMode.PARALLEL;
    }

    @Override
    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context, GFNode[] args) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehavior.one();
    }

    @Override
    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs) {
        return new OlapGenericTwoExprApplyLambdaPreparedInstr(callInstr, args, (OlapFunction)this, pArgs, (x$0, x$1, x$2, x$3, x$4) -> new Callback(this, x$0, x$1, x$2, x$3, x$4));
    }

    protected abstract OlapSetCalculatorTwoExpression createCalculator();

    class Callback
    extends GFApplyLambdaCallback<GFGenericApplyLambdaNode> {
        private volatile OlapSetCalculatorTwoExpression calculator;
        final /* synthetic */ OlapBaseStatisticalTwoExprFunction this$0;

        Callback(OlapBaseStatisticalTwoExprFunction this$0, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, int internalTupleListCount, int limit) {
            OlapBaseStatisticalTwoExprFunction olapBaseStatisticalTwoExprFunction = this$0;
            Objects.requireNonNull(olapBaseStatisticalTwoExprFunction);
            this.this$0 = olapBaseStatisticalTwoExprFunction;
            super(functionCallInstr, functionCallArgInstrs, function, "numeric_expression");
        }

        @Override
        public OlapLambdaCallbackMode processingMode() {
            return this.this$0.getProcessingMode();
        }

        @Override
        public void init(GFContext context, OlapTupleSet set, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args) {
            this.calculator = this.this$0.createCalculator();
        }

        @Override
        public void initX(GFContext context, boolean parallel, OlapTupleSet set, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args) {
            if (parallel && this.calculator != null) {
                this.calculator = new OlapSetCalculatorTwoExpressionMT(this.calculator);
            }
        }

        @Override
        public void onScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapScalarEntity value1, OlapScalarEntity value2) {
            if (this.calculator != null && !value1.isMdxNull() && !value2.isMdxNull()) {
                if (value1 instanceof OlapNumericEntity && value2 instanceof OlapNumericEntity) {
                    OlapNumericEntity y = (OlapNumericEntity)value1;
                    OlapNumericEntity x = (OlapNumericEntity)value2;
                    this.calculator.addValue(x.doubleValue(), y.doubleValue());
                } else if (!(value1 instanceof OlapNumericEntity)) {
                    this.onFunctionArgTypeMismatchError(context, 1, "numeric", value1.getFriendlyTypeName());
                } else {
                    this.onFunctionArgTypeMismatchError(context, 2, "numeric", value1.getFriendlyTypeName());
                }
            }
        }

        @Override
        public OlapEntity onDone(GFContext context) {
            if (this.calculator == null || this.calculator.isResultEmpty()) {
                return OlapBaseStatisticalTwoExprFunction.asEmpty();
            }
            double value = this.calculator.calculate();
            return new OlapNumericEntity(value);
        }
    }
}

