/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.member;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxTimeNavigationFunction;
import java.io.Serializable;

public class OlapParallelPeriodFunction
extends OlapMdxTimeNavigationFunction {
    public static final String NAME = "ParallelPeriod";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(0, 3){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 1: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapParallelPeriodFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapMember member;
        if (args.isMissingArg(0)) {
            return this.onZeroArgumentsForCluster(context, args);
        }
        OlapLevel level = args.toLevel(context, 0);
        int index = args.isMissingArg(1) ? 1 : args.toInteger(context, 1);
        if (args.isMissingArg(2) ? (member = args.getNullableCurrentMember(context, level.getHierarchy())) == null : (member = args.toMember(context, 2, true)) == null || member.isMdxNull()) {
            return OlapParallelPeriodFunction.asNull();
        }
        OlapHierarchy mhierarchy = member.getHierarchy();
        if (!level.getHierarchy().equals(mhierarchy)) {
            return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.DIFFERENT_HIERARCHIES, new Serializable[]{level.getHierarchy().getUniqueName(args.getNameContext(context)), mhierarchy.getUniqueName(args.getNameContext(context))});
        }
        OlapMember ancestor = member.getAncestor(level);
        if (ancestor == null) {
            return OlapParallelPeriodFunction.asNull();
        }
        OlapMember lancestor = ancestor.lag(args.getMemberFilter(context), index);
        if (lancestor == null) {
            return OlapParallelPeriodFunction.asNull();
        }
        return OlapParallelPeriodFunction.asNullable(member.cousin(args.getMemberFilter(context), lancestor));
    }

    private OlapNonScalarEntity onZeroArgumentsForCluster(GFContext context, GFFunctionArgs args) {
        OlapHierarchy timeHierarchy = args.getDefaultTimeHierarchy(context);
        if (timeHierarchy == null) {
            return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.TIME_MISSING_DEFAULT_HIERARCHY_X, new Serializable[]{args.getUnderlyingCubeName(context)});
        }
        OlapMember member = args.getNullableCurrentMember(context, timeHierarchy);
        if (member != null && member.getParent() == null) {
            return OlapNullEntity.INSTANCE;
        }
        return OlapParallelPeriodFunction.asNullable(member);
    }
}

