/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.member;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxTimeNavigationFunction;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBasePeriodFunction
extends OlapMdxTimeNavigationFunction {
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(0, 2){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapBasePeriodFunction(String name) {
        super(name, ARGS);
    }

    protected abstract OlapNonScalarEntity period(@Nullable OlapMemberFilter var1, OlapLevel var2, OlapMember var3);

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapMember member;
        OlapLevel level;
        if (args.isMissingArg(0)) {
            IOlapHierarchyPermission permissions;
            OlapHierarchy timeHierarchy = args.getDefaultTimeHierarchy(context);
            if (timeHierarchy == null) {
                return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.TIME_MISSING_DEFAULT_HIERARCHY_X, new Serializable[]{args.getUnderlyingCubeName(context), Integer.valueOf(0)});
            }
            OlapMember member2 = this.getDefaultMemberForCluster(context, args, timeHierarchy);
            OlapLevel nextLevel = member2.getLevel().getNextLevel();
            if (nextLevel != null && !(permissions = args.getHierarchyPermissionsWithoutPerspective(context, member2.getHierarchy())).isLevelAuthorized(nextLevel)) {
                nextLevel = null;
            }
            level = nextLevel == null ? member2.getLevel() : nextLevel;
        } else {
            level = args.toLevel(context, 0);
        }
        if (args.isMissingArg(1)) {
            OlapHierarchy hierarchy = level.getHierarchy();
            member = this.getDefaultMemberForCluster(context, args, hierarchy);
        } else {
            OlapEntity arg1 = args.getNonMissingArgEntity(context, 1, "member");
            if (arg1.isMdxNull()) {
                return OlapBasePeriodFunction.asNull();
            }
            member = args.toMember(context, 1);
        }
        this.assertSameHierarchy(args.getErrorContext(context), level, member);
        return this.period(args.getMemberFilter(context), level, member);
    }

    private OlapMember getDefaultMemberForCluster(GFContext context, GFFunctionArgs args, OlapHierarchy timeHierarchy) {
        OlapMember member = args.getNullableCurrentMember(context, timeHierarchy);
        if (member == null && (member = timeHierarchy.getNullableDefaultMember(args.getMemberFilter(context))) == null) {
            return (OlapMember)args.onFunctionError(context, OlapErrorCode.TIME_MISSING_DEFAULT_MEMBER, new Serializable[]{timeHierarchy.getUniqueName(args.getNameContext(context)), args.getUnderlyingCubeName(context)});
        }
        return member;
    }
}

