/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.mdx.hierarchy;

import crazydev.common.mdx.error.CdMdxException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.scalar.OlapAbstractStringEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import crazydev.iccube.olap.eval.select.context.OlapMdxEntityLookupKinds;
import java.io.Serializable;

public class OlapDimensionsFunction
extends OlapMdxNavigationFunction {
    public static final String NAME = "Dimensions";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 0: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapDimensionsFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapScalarEntity hierarchy = args.toValueIfApplicable(context, 0, "numeric|string");
        if (hierarchy != null) {
            if (hierarchy instanceof OlapAbstractStringEntity) {
                OlapDimension dimension;
                OlapEntityIdentifier id;
                String name = ((OlapAbstractStringEntity)hierarchy).value();
                try {
                    id = args.compileIdentifier(context, name);
                }
                catch (CdMdxException ex) {
                    return (OlapNonScalarEntity)args.onFunctionError(context, ex);
                }
                OlapNonScalarEntity entity = args.lookupEntityByMdxIdentifier(context, args.getNameContext(context), OlapMdxEntityLookupKinds.ALL_BUT_SET, id);
                if (entity instanceof OlapHierarchy) {
                    return entity;
                }
                if (entity instanceof OlapDimension && (dimension = (OlapDimension)entity).isMeasures()) {
                    return dimension.getMeasureHierarchy();
                }
                return (OlapNonScalarEntity)this.onFunctionError(args.getErrorContext(context, 0), OlapErrorCode.UNKNOWN_ENTITY, new Serializable[]{name});
            }
            if (hierarchy instanceof OlapNumericEntity) {
                int index = ((OlapNumericEntity)hierarchy).intValue();
                OlapNonScalarEntity xHierarchy = args.lookupHierarchy(context, index);
                if (!xHierarchy.isMdxNull()) {
                    return xHierarchy;
                }
                return (OlapNonScalarEntity)args.onFunctionError(context, 0, OlapErrorCode.OUT_OF_RANGE, new Serializable[]{"index", index + "[0 : " + args.getHierarchyCount(context) + "["});
            }
        }
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "numeric|string");
        return (OlapNonScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "numeric|string", arg0.getFriendlyTypeName());
    }
}

