/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function.extra;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactory;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;

public class OlapNonEmptyBehaviorFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "ic3nonEmptyBehavior";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 2){

        @Override
        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return super.getType(pos);
        }
    };

    public OlapNonEmptyBehaviorFunction() {
        super(NAME, ARGS);
    }

    @Override
    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapTuple dimensionalityTuple;
        OlapEntity arg1;
        OlapEntity arg0 = args.getNonMissingArgEntity(context, 0, "member");
        OlapEntity olapEntity = arg1 = !args.isMissingArg(1) ? args.getNonMissingArgEntity(context, 1, "tuple") : null;
        if (arg1 != null && !(arg1 instanceof OlapTuple)) {
            return (OlapScalarEntity)args.onFunctionArgTypeMismatchError(context, 1, "tuple", arg1.getFriendlyTypeName());
        }
        OlapTuple olapTuple = dimensionalityTuple = arg1 != null ? (OlapTuple)arg1 : null;
        if (arg0 instanceof OlapMember) {
            OlapMember member = (OlapMember)arg0;
            try {
                OlapTupleDimensionality dimensionality = dimensionalityTuple == null ? OlapTupleDimensionalityFactory.createForBlankTuple() : dimensionalityTuple.getTupleDimensionality();
                S_NonEmptyBehaviorFactoryContext nonEmptyBehaviorContext = context.createNonEmptyBehaviorContext(dimensionality);
                S_NonEmptyBehavior behavior = S_NonEmptyBehaviorFactory.createForMember(nonEmptyBehaviorContext, member);
                OlapStringEntity res = behavior.asMdxResult();
                return res;
            }
            catch (OlapNonEmptyBehaviorException ex) {
                OlapLoggers.MDX_EVALUATION.error((Object)("non empty behavior setup error for member [" + ONames.uname4Log(member) + "]"), (Throwable)ex);
                throw new OlapFunctionEvaluationException(args.getErrorContext(context, 0), NAME, OlapErrorCode.NON_EMPTY_BEHAVIOR_ERROR, new Serializable[]{member.getNameX(), ex.getMessage()});
            }
        }
        return (OlapScalarEntity)args.onFunctionArgTypeMismatchError(context, 0, "member", arg0.getFriendlyTypeName());
    }
}

