/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;

public class OlapNoArgFunctionCallInstr
extends OlapFunctionCallInstr {
    private final OlapFunction function;

    public OlapNoArgFunctionCallInstr(OlapInstrLocationRange range, OlapFunctionCallInstr.Notation notation, OlapFunction function) {
        super(range, notation, function.getName());
        this.function = function;
    }

    @Override
    public String typeForError() {
        return "FUNCTION CALL";
    }

    @Override
    public boolean isSubCubeXyz() {
        return this.function.isSubCubeXyz();
    }

    @Override
    public int getArgCount() {
        return 0;
    }

    @Override
    public OlapInstr getArg(int pos) {
        throw new CdProgrammingException("Missing argument [" + pos + "]");
    }

    @Override
    protected OlapFunction resolveFunction(IOlapPrepareContext context) {
        return this.function;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }
}

