/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.eval.exception.OlapStackOverflowEvaluationException;
import crazydev.iccube.olap.eval.execinstr.OlapIsErrorFunctionCallPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapIsErrorInstrPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapIsErrorTrueFunctionCallPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapSingleArgFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import org.jetbrains.annotations.Nullable;

public class OlapIsErrorFunctionCallInstr
extends OlapSingleArgFunctionCallInstr {
    public OlapIsErrorFunctionCallInstr(OlapInstrLocationRange range, OlapFunctionCallInstr.Notation notation, OlapFunction function, OlapInstr arg) {
        super(range, notation, function, arg);
    }

    @Override
    @Nullable
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        OlapFunction function = this.resolveFunction(context);
        this.assertUsage(context, function);
        OlapInstr[] args = new OlapInstr[this.getArgCount()];
        for (int ii = 0; ii < args.length; ++ii) {
            args[ii] = this.getArg(ii);
        }
        try {
            OlapPreparedInstr[] pArgs = new OlapPreparedInstr[args.length];
            for (int ii = 0; ii < pArgs.length; ++ii) {
                OlapPreparedInstr pArg;
                pArgs[ii] = pArg = args[ii].prepare(context);
            }
            return new OlapIsErrorFunctionCallPreparedInstr(this, args, function, pArgs);
        }
        catch (OlapException ex) {
            if (ex instanceof OlapStackOverflowEvaluationException) {
                throw ex;
            }
            OlapPreparedInstr[] pArgs_ = new OlapPreparedInstr[]{new OlapIsErrorInstrPreparedInstr(args[0])};
            return new OlapIsErrorTrueFunctionCallPreparedInstr(this, args, function, pArgs_);
        }
    }
}

