/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberProperty;
import crazydev.iccube.olap.eval.execinstr.OlapIntrinsicMemberPropertyCallPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.function.OlapCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;

public class OlapIntrinsicMemberPropertyCallInstr
extends OlapCallInstr {
    private final OlapIntrinsicMemberProperty property;
    private OlapInstr member;

    public OlapIntrinsicMemberPropertyCallInstr(OlapInstrLocationRange range, OlapIntrinsicMemberProperty property, OlapInstr member) {
        super(range);
        this.property = property;
        this.setupMember(member);
    }

    @Override
    public String toStringForDebugger() {
        return "." + this.property.getName();
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.member.accept(v);
        }
    }

    @Override
    public String typeForError() {
        return "PROPERTY CALL";
    }

    private void setupMember(OlapInstr instr) {
        this.member = instr;
        this.member.setParent(this);
    }

    public OlapMemberProperty getProperty() {
        return this.property;
    }

    public OlapInstr getMember() {
        return this.member;
    }

    @Override
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        OlapPreparedInstr pMember = this.member.prepare(context);
        return new OlapIntrinsicMemberPropertyCallPreparedInstr(this, this.property, pMember);
    }
}

