/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.lambda.OlapFunctionEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.OlapFunctionIdentifierPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.function.OlapExecutedWithPreparedInstr;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import java.io.Serializable;

public class OlapFunctionIdentifierInstr
extends OlapExecutedWithPreparedInstr<OlapEvaluationContext> {
    private final String name;

    public OlapFunctionIdentifierInstr(OlapInstrLocationRange range, String name) {
        super(range);
        this.name = name;
    }

    @Override
    public String typeForError() {
        return "FUNCTION";
    }

    @Override
    public boolean isConstrainedEnabled() {
        return false;
    }

    @Override
    public String toStringForDebugger() {
        return this.name;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected synchronized OlapEntity doExecute(OlapEvaluationContext context) {
        OlapFunction function = context.lookupFunction(this.name);
        if (function == null) {
            throw new OlapFunctionEvaluationException((IOlapEvaluationExceptionContext)context, this.name, OlapErrorCode.MDX_FUNCTION_UNRESOLVED, new Serializable[]{this.name});
        }
        return new OlapFunctionEntity(function);
    }

    @Override
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        return new OlapFunctionIdentifierPreparedInstr(this, this.name);
    }

    public String toString() {
        return this.name;
    }
}

