/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.function.OlapCallInstr;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.io.Serializable;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public abstract class OlapFunctionCallInstr
extends OlapCallInstr {
    private final Notation notation;
    private final String functionName;

    public OlapFunctionCallInstr(OlapInstrLocationRange range, Notation notation, String functionName) {
        super(range);
        this.notation = notation;
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public abstract int getArgCount();

    public abstract OlapInstr getArg(int var1);

    @Nullable
    public OlapInstrLocationRange getFunctionArgumentRange(int argIndex) {
        if (argIndex >= 0 && argIndex < this.getArgCount()) {
            return this.getArg(argIndex).getLocationRange();
        }
        return null;
    }

    @Override
    @Nullable
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        OlapFunction function = this.resolveFunction(context);
        this.assertUsage(context, function);
        OlapInstr[] args = new OlapInstr[this.getArgCount()];
        for (int ii = 0; ii < args.length; ++ii) {
            args[ii] = this.getArg(ii);
        }
        if (!function.getArgsInfo().inRange(args.length)) {
            IOlapEvaluationExceptionContext errContext = this.createErrorContext(Locale.ENGLISH, OlapNameContext.DEFAULT_VALUES, false);
            String expected = function.getArgsInfo().to + "," + function.getArgsInfo().from;
            throw new OlapFunctionEvaluationException(errContext, this.getFunctionName(), OlapErrorCode.FUNCTION_UNEXPECTED_ARGUMENT_COUNT, new Serializable[]{Integer.valueOf(args.length), expected});
        }
        return function.prepare(context, this, args);
    }

    public int getLambdaLimit() {
        return -1;
    }

    protected abstract OlapFunction resolveFunction(IOlapPrepareContext var1);

    protected void assertUsage(IOlapPrepareContext context, OlapFunction function) {
        if (!context.isAcceptingFunctionCall(function)) {
            throw new OlapFunctionEvaluationException((IOlapEvaluationExceptionContext)context, this.functionName, OlapErrorCode.MDX_FUNCTION_USAGE, new Serializable[]{context.getUsage()});
        }
    }

    @Override
    public String toStringForDebugger() {
        return this.functionName + "()";
    }

    public String toString() {
        return this.functionName;
    }

    public static enum Notation {
        FUNCTION_REGULAR,
        FUNCTION_POST_FIXED,
        FUNCTION_SET_ITEM_OPERATOR;

    }
}

