/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapFunctionArgumentType {
    public static final OlapFunctionArgumentType ANY = new OlapFunctionArgumentType("<any>");
    public static final OlapFunctionArgumentType SUBCUBE = new OlapFunctionArgumentType("<subcube>");
    public static final OlapFunctionArgumentType VALUE = new OlapFunctionArgumentType("<value>");
    private static final Set<String> VALUABLES = new HashSet<String>();
    private final String lexeme;

    private OlapFunctionArgumentType(String lexeme) {
        this.lexeme = lexeme;
    }

    public boolean isValuable() {
        return this == VALUE || VALUABLES.contains(this.lexeme);
    }

    public static void registerValuable(String ... lexemes) {
        if (lexemes == null) {
            return;
        }
        for (String lexeme : lexemes) {
            if (lexeme == null) continue;
            VALUABLES.add(lexeme);
        }
    }

    public static OlapFunctionArgumentType create(String functionName, String argName, @Nullable String argType) {
        if (argType == null) {
            return ANY;
        }
        if ("value".equalsIgnoreCase(argType)) {
            return VALUE;
        }
        return new OlapFunctionArgumentType(argType);
    }

    public String toString() {
        return this.lexeme;
    }

    static {
        OlapFunctionArgumentType.registerValuable("double", "Double");
        OlapFunctionArgumentType.registerValuable("float", "Float");
        OlapFunctionArgumentType.registerValuable("long", "Long");
        OlapFunctionArgumentType.registerValuable("int", "Integer");
        OlapFunctionArgumentType.registerValuable("short", "Short");
        OlapFunctionArgumentType.registerValuable("byte", "Byte");
        OlapFunctionArgumentType.registerValuable("boolean", "Boolean");
        OlapFunctionArgumentType.registerValuable("String");
        OlapFunctionArgumentType.registerValuable("LocalDate", "LocalDateTime");
        OlapFunctionArgumentType.registerValuable("IOlapScalar");
        OlapFunctionArgumentType.registerValuable("IOlapNumeric");
        OlapFunctionArgumentType.registerValuable("IOlapDoubleVector");
        OlapFunctionArgumentType.registerValuable("IOlapComparableList");
        OlapFunctionArgumentType.registerValuable("ITidyTable");
    }
}

