/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdErrorLocation;
import crazydev.common.mdx.error.CdMdxException;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapFunctionError;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.exception.OlapCompilationException;
import crazydev.iccube.olap.compiler.exception.OlapCompilationExceptionContext;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.scalar.OlapTruncatedString;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.OlapFunctionCallPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapInvalidOptionPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapFunctionDescriptionRepository;
import crazydev.iccube.olap.eval.id.OlapIdentifierInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class OlapFunction {
    protected final String name;
    private final OlapFunctionArgs argsInfo;

    protected OlapFunction(String name, OlapFunctionArgs argsInfo) {
        this.name = name;
        this.argsInfo = argsInfo;
    }

    public abstract boolean isScalar();

    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context, GFNode[] args) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehavior.one();
    }

    protected S_NonEmptyBehavior nonEmptyBehaviorStats(S_NonEmptyBehaviorFactoryContext context, GFNode[] args) throws OlapNonEmptyBehaviorException {
        OlapTupleDimensionality arg0dimensionality = args[0].getTupleDimensionality();
        OlapTupleDimensionality wholeDimensionality = context.getWholeDimensionality();
        if (arg0dimensionality != null && !wholeDimensionality.intersects(arg0dimensionality)) {
            GFNode lambda = args[1];
            return lambda.nonEmptyBehavior(context);
        }
        return S_NonEmptyBehavior.one();
    }

    public boolean withPostFixedNotation() {
        return true;
    }

    public boolean isDeclared() {
        return false;
    }

    public boolean isSubCubeXyz() {
        return false;
    }

    public final String getName() {
        return this.name;
    }

    public final OlapFunctionArgs getArgsInfo() {
        return this.argsInfo;
    }

    public int getLambdaLimit(OlapInstr[] args) {
        return -1;
    }

    protected <T> T onFunctionArgTypeMismatchError(IOlapEvaluationExceptionContext errorContext, int argNb, String expectedType, String actualType) {
        return this.onFunctionError(errorContext, OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{Integer.valueOf(argNb), expectedType, actualType, ""});
    }

    protected static <T> T onFunctionArgTypeMismatchErrorS(String name, IOlapEvaluationExceptionContext errorContext, int argNb, String expectedType, String actualType) {
        return OlapFunction.onFunctionErrorS(name, errorContext, OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{Integer.valueOf(argNb), expectedType, actualType, ""});
    }

    protected <T> T onFunctionArgTypeMismatchError(IOlapEvaluationExceptionContext errorContext, int argNb, String expectedType, String actualType, @Nullable String extraInfo) {
        return this.onFunctionError(errorContext, OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{Integer.valueOf(argNb), expectedType, actualType, extraInfo});
    }

    protected <T> T onFunctionError(IOlapEvaluationExceptionContext context, CdMdxException scanError) {
        CdError error = scanError.getError();
        CdErrorCode code = scanError.getErrorCode();
        CdErrorLocation location = scanError.getLocation();
        OlapInstrLocationRange functionLocation = context.getErrorLocation();
        OlapFunctionError<OlapInstrLocationRange, CdErrorCode> functionError = new OlapFunctionError<OlapInstrLocationRange, CdErrorCode>(functionLocation, this.getName(), code, error.getParams());
        throw new OlapFunctionEvaluationException(functionError);
    }

    protected <T> T onFunctionError(IOlapEvaluationExceptionContext errorContext, OlapErrorCode errCode, Serializable ... params) {
        throw new OlapFunctionEvaluationException(errorContext, this.getName(), errCode, params);
    }

    protected static <T> T onFunctionErrorS(String name, IOlapEvaluationExceptionContext errorContext, OlapErrorCode errCode, Serializable ... params) {
        throw new OlapFunctionEvaluationException(errorContext, name, errCode, params);
    }

    protected static OlapNonScalarEntity asNull() {
        return OlapNullEntity.INSTANCE;
    }

    protected static OlapScalarEntity asEmpty() {
        return OlapEmptyEntity.INSTANCE;
    }

    protected static OlapNonScalarEntity asNullable(@Nullable OlapNonScalarEntity entity) {
        return entity == null ? OlapFunction.asNull() : entity;
    }

    protected static OlapScalarEntity asNullable(@Nullable OlapScalarEntity entity) {
        return entity == null ? OlapFunction.asEmpty() : entity;
    }

    protected OlapBooleanEntity asBoolean(boolean value) {
        return OlapBooleanEntity.value(value);
    }

    protected OlapNumericEntity asInteger(int number) {
        return new OlapNumericEntity(number);
    }

    protected OlapBooleanEntity asFalse() {
        return OlapBooleanEntity.FALSE;
    }

    protected OlapBooleanEntity asTrue() {
        return OlapBooleanEntity.TRUE;
    }

    protected void assertSameHierarchy(IOlapEvaluationExceptionContext errContext, OlapLevel level, OlapMember member) {
        if (member.getHierarchy() != level.getHierarchy()) {
            OlapNameContext nameContext = errContext.getNameContext();
            throw new OlapEvaluationException(errContext, OlapErrorCode.DIFFERENT_HIERARCHIES, new Serializable[]{level.getHierarchy().getUniqueName(nameContext), member.getHierarchy().getUniqueName(nameContext)});
        }
    }

    public String getMdxGroupName() {
        return OlapFunctionDescriptionRepository.getMdxGroupName(this.name);
    }

    @Nullable(value="If standard MDX library.")
    public @Nullable(value="If standard MDX library.") String getLibraryName() {
        return null;
    }

    public String getDescription() {
        return OlapFunctionDescriptionRepository.getDescription(this.name);
    }

    public String getParametersDescription() {
        return OlapFunctionDescriptionRepository.getParameters(this.name);
    }

    public boolean isUserDefined() {
        return false;
    }

    public String getActualJavaClassName() {
        return this.getClass().getName();
    }

    @Nullable
    public OlapInstr asInstr(OlapCompilationContext context, OlapInstrLocationRange location, OlapFunctionCallInstr.Notation mdxNotation, OlapInstr[] args) {
        return null;
    }

    protected void assertArgumentCount(OlapCompilationExceptionContext errorContext, OlapInstr[] args) {
        if (args.length < this.getArgsInfo().from || this.getArgsInfo().to < args.length) {
            this.onFunctionCompilationArgumentCountError(errorContext, this.getName(), args.length, this.getArgsInfo().getDescription());
        }
    }

    protected <T> T onFunctionCompilationArgumentCountError(OlapCompilationExceptionContext errorContext, String functionName, int actual, String expected) {
        return this.onFunctionCompilationError(errorContext, OlapErrorCode.FUNCTION_UNEXPECTED_ARGUMENT_COUNT_X, new Serializable[]{functionName, Integer.valueOf(actual), expected});
    }

    private <T> T onFunctionCompilationError(OlapCompilationExceptionContext errorContext, OlapErrorCode errCode, Serializable ... params) {
        throw new OlapCompilationException(errorContext, errCode, params);
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapPreparedInstr prepare(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args) {
        Object mark = context.markAsNamedSet();
        try {
            OlapPreparedInstr[] pArgs = this.doPrepareFunctionArgs(context, args);
            OlapPreparedInstr olapPreparedInstr = this.doPrepareFunctionCall(context, callInstr, args, pArgs);
            return olapPreparedInstr;
        }
        finally {
            context.resetAsNamedSetToMark(mark);
        }
    }

    protected OlapPreparedInstr[] doPrepareFunctionArgs(IOlapPrepareContext context, OlapInstr[] args) {
        OlapPreparedInstr[] pArgs = new OlapPreparedInstr[args.length];
        for (int ii = 0; ii < pArgs.length; ++ii) {
            OlapInstr arg = args[ii];
            boolean isOption = this.argsInfo.isOption(ii);
            OlapPreparedInstr pArg = isOption && arg instanceof OlapIdentifierInstr ? new OlapInvalidOptionPreparedInstr((OlapIdentifierInstr)arg) : arg.prepare(context);
            pArgs[ii] = pArg;
        }
        return pArgs;
    }

    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs) {
        return new OlapFunctionCallPreparedInstr(callInstr, args, this, pArgs);
    }

    @Nullable(value="if the dimensionality cannot be determined")
    public @Nullable(value="if the dimensionality cannot be determined") OlapTupleDimensionality getTupleDimensionality(GFNode[] args) {
        return null;
    }

    @Nullable
    protected OlapTupleDimensionality getTupleDimensionality(GFNode[] args, int index) {
        if (index >= 0 && index < args.length) {
            return args[index].getTupleDimensionality();
        }
        return null;
    }

    protected OlapLevel getParentLevelOfTimeCurrentMemberForCluster(GFContext context, GFFunctionArgs args, int argNb) {
        OlapHierarchy timeHierarchy = args.getDefaultTimeHierarchy(context);
        if (timeHierarchy == null) {
            return (OlapLevel)args.onFunctionError(context, OlapErrorCode.TIME_MISSING_DEFAULT_HIERARCHY_X, new Serializable[]{args.getUnderlyingCubeName(context), Integer.valueOf(argNb)});
        }
        OlapMember member = args.getNullableCurrentMember(context, timeHierarchy);
        if (member == null) {
            return (OlapLevel)args.onFunctionError(context, OlapErrorCode.TIME_MISSING_CURRENT_MEMBER, new Serializable[]{ONames.uname4Log(timeHierarchy), args.getUnderlyingCubeName(context)});
        }
        OlapLevel level = member.getLevel();
        OlapLevel parentLevel = level.getPreviousLevel();
        return parentLevel == null ? level : parentLevel;
    }

    protected OlapStringEntity toMdxString(GFContext context, GFFunctionArgs args, int argNb, OlapNonScalarEntity entity) {
        OlapProperties properties = args.getRequestProperties(context);
        int strMaxSize = properties.getToStrMaxSize();
        OlapNameContext nameContext = args.getNameContext(context);
        try {
            String str = entity.toMdxString(nameContext, false, strMaxSize);
            return new OlapStringEntity(str);
        }
        catch (OlapTruncatedString ex) {
            return (OlapStringEntity)this.onFunctionError(args.getErrorContext(context, argNb), OlapErrorCode.TO_STR_MAX_SIZE, Integer.valueOf(strMaxSize));
        }
    }

    public abstract OlapEntity evalForCluster(GFContext var1, GFFunctionArgs var2);
}

