/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.result.OlapResDropFunctionBlankStatementDataSet;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.OlapScriptCommandStatementInstr;
import crazydev.iccube.olap.eval.select.context.OlapDropFunctionStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDropFunctionStatementInstr
extends OlapScriptCommandStatementInstr<OlapDropFunctionStatementExecutionContext> {
    private final List<String> names;

    public OlapDropFunctionStatementInstr(OlapInstrLocationRange range, List<String> names) {
        super(range);
        this.names = names;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.WRITE;
    }

    @Override
    public String typeForError() {
        return "DROP FUNCTION";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected OlapDropFunctionStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapDropFunctionStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapDropFunctionStatementExecutionContext context) {
        this.assertAuthorizationForDropStatement(context);
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResDropFunctionBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        StringBuilder sb = new StringBuilder();
        for (String name : this.names) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.names);
            schema.removeDeclaredFunction(context.getErrorLocation(), context.getSchemaPermissions(), name);
        }
        this.onScriptStatementApplied(context, schema, true);
        return new OlapResDropFunctionBlankStatementDataSet(schema.getName(), "?", sb.toString());
    }

    @Override
    public String toStringForDebugger() {
        return "DROP FUNCTION : " + this.names.toString();
    }
}

