/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.io.Serializable;

public class OlapDeclaredFunctionCallInstr
extends OlapFunctionCallInstr {
    private final OlapInstr[] args;

    public OlapDeclaredFunctionCallInstr(OlapInstrLocationRange range, OlapFunctionCallInstr.Notation notation, String functionName, OlapInstr ... args) {
        super(range, notation, functionName);
        this.args = args;
        for (OlapInstr arg : args) {
            arg.setParent(this);
        }
    }

    @Override
    public String typeForError() {
        return "FUNCTION CALL";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            for (OlapInstr arg : this.args) {
                arg.accept(v);
            }
        }
    }

    @Override
    public int getArgCount() {
        return this.args.length;
    }

    @Override
    public OlapInstr getArg(int pos) {
        if (pos < 0 || pos >= this.args.length) {
            throw new CdProgrammingException("Missing argument [" + pos + "]");
        }
        return this.args[pos];
    }

    @Override
    protected OlapFunction resolveFunction(IOlapPrepareContext context) {
        String functionName = this.getFunctionName();
        OlapDeclaredFunction function = context.lookupDeclaredFunction(functionName);
        if (function == null) {
            throw new OlapFunctionEvaluationException((IOlapEvaluationExceptionContext)context, functionName, OlapErrorCode.MDX_FUNCTION_UNRESOLVED, new Serializable[]{functionName});
        }
        return function;
    }
}

