/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapUnresolvedFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunctionParameter;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;

public class OlapDeclaredFunctionArgumentCallInstr
extends OlapFunctionCallInstr {
    private final String declaredFunctionName;
    private final OlapDeclaredFunctionParameter declaredFunctionArgument;
    private final OlapInstr[] args;

    public OlapDeclaredFunctionArgumentCallInstr(OlapInstrLocationRange range, String declaredFunctionName, OlapDeclaredFunctionParameter declaredFunctionArgument, OlapInstr ... args) {
        super(range, OlapFunctionCallInstr.Notation.FUNCTION_REGULAR, declaredFunctionArgument.getName());
        this.declaredFunctionName = declaredFunctionName;
        this.declaredFunctionArgument = declaredFunctionArgument;
        this.args = args;
        for (OlapInstr arg : args) {
            arg.setParent(this);
        }
    }

    @Override
    public String typeForError() {
        return "FUNCTION ARGUMENT CALL";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            for (OlapInstr arg : this.args) {
                arg.accept(v);
            }
        }
    }

    @Override
    public int getArgCount() {
        return this.args.length;
    }

    @Override
    public OlapInstr getArg(int pos) {
        if (pos < 0 || pos >= this.args.length) {
            throw new CdProgrammingException("Missing argument [" + pos + "]");
        }
        return this.args[pos];
    }

    @Override
    protected OlapFunction resolveFunction(IOlapPrepareContext context) {
        return new OlapUnresolvedFunction(this.declaredFunctionArgument);
    }
}

