/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.function;

import crazydev.common.javacompiler.CompiledCode;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.result.OlapResCreateFunctionBlankStatementDataSet;
import crazydev.iccube.olap.eval.create.OlapCreateStatementInstr;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.function.mdx.OlapConstDeclaredFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunctionParameter;
import crazydev.iccube.olap.eval.function.mdx.OlapStaticNoParamDeclaredFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapStaticWithParamDeclaredFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapCreateFunctionStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepository;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapCreateFunctionStatementInstr
extends OlapCreateStatementInstr<OlapCreateFunctionStatementExecutionContext> {
    private final OlapInstrLocationRange idRange;
    private final boolean constant;
    private final boolean staticEvaluation;
    private final String name;
    private final List<OlapDeclaredFunctionParameter> argNames;
    private final OlapInstr body;
    @Nullable
    private final String cubeName;
    private final boolean cached;

    public OlapCreateFunctionStatementInstr(OlapInstrLocationRange idRange, OlapInstrLocationRange range, boolean constant, boolean staticEvaluation, String name, List<OlapDeclaredFunctionParameter> argNames, OlapInstr body, @Nullable String cubeName, boolean cached) {
        super(range);
        this.idRange = idRange;
        this.constant = constant;
        this.staticEvaluation = staticEvaluation;
        this.name = name;
        this.argNames = argNames;
        this.body = body;
        this.cubeName = cubeName;
        this.cached = cached;
        this.body.setParent(this);
    }

    @Override
    public String typeForError() {
        return "CREATE FUNCTION";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.body.accept(v);
        }
    }

    @Override
    protected OlapCreateFunctionStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapCreateFunctionStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapCreateFunctionStatementExecutionContext context) {
        boolean forPhaseI;
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        if (!perms.isBuilderEnabled()) {
            throw new OlapEvaluationException(context, OlapErrorCode.NOT_AUTHORIZED, new Serializable[]{"app.builder"});
        }
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResCreateFunctionBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        OlapDeclaredFunction function = this.constant ? new OlapConstDeclaredFunction(this.name, this.body, this.cached) : (this.staticEvaluation ? (this.argNames.isEmpty() ? new OlapStaticNoParamDeclaredFunction(false, this.name, this.argNames, this.body, this.cubeName, this.cached) : new OlapStaticWithParamDeclaredFunction(false, this.name, this.argNames, this.body, this.cubeName, this.cached)) : new OlapDeclaredFunction(this.name, this.argNames, this.body));
        OlapSchemaFunctionRepository repository = schema.getFunctionRepository();
        CompiledCode javaNativeCode = null;
        if (function.isNativeJava() && !(forPhaseI = context.isForPhaseI())) {
            javaNativeCode = schema.generateNativeFunctionByteCode(context, function);
        }
        repository.addDeclaredFunctionIfNotContained(this.idRange, context.getSchemaPermissions(), function);
        if (javaNativeCode != null) {
            schema.registerNativeFunctions(javaNativeCode);
        }
        this.onScriptStatementApplied(context, schema, true);
        return new OlapResCreateFunctionBlankStatementDataSet(schema.getName(), "?", function.getName());
    }

    @Override
    public String toStringForDebugger() {
        return "CREATE FUNCTION : " + this.name;
    }
}

