/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.filter.dimension;

import crazydev.common.collection.CdSortedList;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.eval.filter.dimension.IOlapSimpleExistsFilter;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import crazydev.iccube.olap.index.bitmap.OlapBitmapAggregation;
import crazydev.iccube.olap.index.bitmap.tor.IBitmapAndTor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapSimpleBitmapExistsFilter
implements IOlapSimpleExistsFilter {
    private final List<Duo> existList;
    @Nullable
    protected final Set<Map.Entry<Integer, CdSortedList<OlapMember>>> sameHierarchy;

    public OlapSimpleBitmapExistsFilter(List<Duo> existList, @Nullable Map<Integer, CdSortedList<OlapMember>> sameHierarchy) {
        this.existList = existList;
        this.sameHierarchy = sameHierarchy == null || sameHierarchy.isEmpty() ? null : sameHierarchy.entrySet();
    }

    @Override
    public boolean isAccepting(IOlapTuple tuple) {
        if (this.sameHierarchy != null && !this.doAcceptSameHierarchy(tuple)) {
            return false;
        }
        for (int i = 0; i < this.existList.size(); ++i) {
            Duo duo = this.existList.get(i);
            OlapBitmap bitmap = duo.bitmap;
            int dimDimensionalityIndex = duo.dimDimensionality;
            IBitmapAndTor andTor = OlapBitmapAggregation.createOlapBitmapAndtor();
            andTor.addForAnd(bitmap);
            int memberCount = tuple.getMemberCount();
            for (int j = 0; j < memberCount; ++j) {
                OlapMember member = tuple.getMember(j);
                if (member.getDimension().getDimensionalityIndex() != dimDimensionalityIndex) continue;
                andTor.addForAnd(member.getBaseMemberBitmap4Exist());
            }
            if (!andTor.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected boolean doAcceptSameHierarchy(IOlapTuple tuple) {
        for (Map.Entry<Integer, CdSortedList<OlapMember>> entry : this.sameHierarchy) {
            CdSortedList<OlapMember> value = entry.getValue();
            OlapMember tupleMember = tuple.getMemberByDimensionality(entry.getKey());
            boolean accepts = false;
            for (int i = 0; i < value.size(); ++i) {
                OlapMember filterMember = (OlapMember)value.get(i);
                if (!this.matchForExistsSameHierarchy(filterMember, tupleMember)) continue;
                accepts = true;
                break;
            }
            if (accepts) continue;
            return false;
        }
        return true;
    }

    protected boolean matchForExistsSameHierarchy(OlapMember filterMember, OlapMember tupleMember) {
        if (tupleMember.isCalculated() || filterMember.isCalculated()) {
            return true;
        }
        return filterMember.isSameBranch(tupleMember);
    }

    public static class Duo {
        final int dimDimensionality;
        final OlapBitmap bitmap;

        public Duo(int dimDimensionality, OlapBitmap bitmap) {
            this.dimDimensionality = dimDimensionality;
            this.bitmap = bitmap;
        }
    }
}

