/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.cells.processor;

import crazydev.common.collection.CdActionEx;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactory;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorOperator;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.fastcj.OlapFastCrossjoinIterator;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFCalcMemberEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFCellTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFCellsTupleEvaluator;
import crazydev.iccube.olap.eval.facts.cells.processor.IOlapCellProcessor;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapCellAxis;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapCellProcessorRegularFactory;
import crazydev.iccube.olap.eval.select.context.OlapCellEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCellsEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class OlapCellProcessorNonEmptyFactory {
    private final OlapSelectStatementExecutionContext context;
    private final boolean isEvalOrdinalOnly;
    private final boolean[] hasNonEmpties;
    private final boolean hasNonEmpty;
    private final OlapTupleSet<OlapTuple>[] axisSets;
    private final OlapIterator<OlapTuple>[] axisTupleIterators;
    private final OlapTupleDimensionality[] axisTupleDimensionalities;
    private final Boolean[] mightHaveCalcMembers;

    private OlapCellProcessorNonEmptyFactory(OlapSelectStatementExecutionContext context, boolean isEvalOrdinalOnly, boolean[] hasNonEmpties, boolean hasNonEmpty, OlapTupleSet<OlapTuple>[] axisSets) {
        this.context = context;
        this.isEvalOrdinalOnly = isEvalOrdinalOnly;
        this.hasNonEmpties = hasNonEmpties;
        this.hasNonEmpty = hasNonEmpty;
        this.axisSets = axisSets;
        this.axisTupleIterators = new OlapIterator[axisSets.length];
        this.axisTupleDimensionalities = new OlapTupleDimensionality[axisSets.length];
        this.mightHaveCalcMembers = new Boolean[axisSets.length];
    }

    public static IOlapCellProcessor create(OlapSelectStatementExecutionContext context, boolean forTidyEvaluation, boolean isEvalOrdinalOnly, OlapTupleSet<OlapTuple>[] axisSets, boolean[] hasNonEmpties, boolean hasNonEmpty) {
        OlapCellProcessorNonEmptyFactory factory = new OlapCellProcessorNonEmptyFactory(context, isEvalOrdinalOnly, hasNonEmpties, hasNonEmpty, axisSets);
        IOlapCellProcessor processor = factory.create(forTidyEvaluation);
        if (processor != null) {
            return processor;
        }
        return OlapCellProcessorRegularFactory.create(context, forTidyEvaluation, isEvalOrdinalOnly, axisSets, hasNonEmpties, true);
    }

    private IOlapCellProcessor create(boolean forTidyEvaluation) {
        for (int ii = 0; ii < this.axisSets.length; ++ii) {
            OlapIterator axisTupleIterator = this.axisSets[ii].getIterator(false);
            OlapTupleDimensionality axisTupleDimensionality = axisTupleIterator.getTupleDimensionality();
            if (axisTupleDimensionality == null) {
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] axis(" + ii + ") unknown dimensionality : fast NON EMPTY fully disabled"));
                return null;
            }
            this.axisTupleIterators[ii] = axisTupleIterator;
            this.axisTupleDimensionalities[ii] = axisTupleDimensionality;
        }
        int axisWithMeasures = this.axisWithMeasures();
        OlapCellAxis[] axes = new OlapCellAxis[this.axisSets.length];
        for (int ii = 0; ii < axes.length; ++ii) {
            axes[ii] = this.setupAxis(axisWithMeasures, ii);
        }
        return IOlapCellProcessor.create(this.context, forTidyEvaluation, this.isEvalOrdinalOnly, axes, true);
    }

    private int axisWithMeasures() {
        Integer axisWithMeasures = null;
        OlapHierarchy measuresHierarchy = this.context.getMeasuresHierarchy();
        for (int ii = 0; ii < this.axisSets.length; ++ii) {
            OlapTupleDimensionality axisTupleDimensionality = this.axisTupleDimensionalities[ii];
            if (!axisTupleDimensionality.isIn(measuresHierarchy)) continue;
            if (axisWithMeasures != null) {
                return -2;
            }
            axisWithMeasures = ii;
        }
        if (axisWithMeasures == null) {
            return -1;
        }
        return axisWithMeasures;
    }

    private OlapCellAxis setupAxis(int axisWithMeasures, int axis) {
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] setup axis " + axis + " [ axis-with-measures: " + axisWithMeasures + " ]"));
        if (!this.hasNonEmpties[axis]) {
            return new OlapCellAxis(axis, false, this.axisTupleIterators[axis], false, this.axisTupleDimensionalities[axis]);
        }
        return this.setupNonEmptyAxis(axisWithMeasures, axis);
    }

    private OlapCellAxis setupNonEmptyAxis(int axisWithMeasures, int axis) {
        OlapIterator<OlapTuple> axisTupleIterator = this.axisTupleIterators[axis];
        OlapTupleDimensionality axisTupleDimensionality = this.axisTupleDimensionalities[axis];
        if (axisWithMeasures == -2) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : non-empty-behaviors duplicated [Measures] (" + axisWithMeasures + ") (" + axis + ")"));
            return new OlapCellAxis(axis, true, axisTupleIterator, false, axisTupleDimensionality);
        }
        if (axisWithMeasures == axis && axisTupleIterator.getTupleDimensionality() != null && axisTupleIterator.getTupleDimensionality().cardinality() == 1) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : contains [Measures]"));
            return new OlapCellAxis(axis, true, axisTupleIterator, false, axisTupleDimensionality);
        }
        if (this.mightHaveCalcMembers(axis)) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : might have a calculated member"));
            return new OlapCellAxis(axis, true, axisTupleIterator, false, axisTupleDimensionality);
        }
        S_NonEmptyBehavior nonEmptyBehaviors = this.setupNonEmptyBehavior(axisWithMeasures, axis);
        if (nonEmptyBehaviors == null) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : non-empty-behaviors could not be setup"));
            return new OlapCellAxis(axis, true, axisTupleIterator, false, axisTupleDimensionality);
        }
        if (nonEmptyBehaviors.hasAggregationWithRollupHierarchy(OlapLoggers.MDX_EVALUATION, "[mdx] ")) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : non-empty-behaviors w/ aggregation w/ rollup hierarchy"));
            return new OlapCellAxis(axis, true, axisTupleIterator, false, axisTupleDimensionality);
        }
        OlapFastCrossjoinContext crossjoinContext = new OlapFastCrossjoinContext(this.context, this.context.asExceptionContext(), nonEmptyBehaviors);
        OlapFastCrossjoinIterator optimizedForNonEmpty = axisTupleIterator.fastCrossjoinForNonEmptyProcessing(crossjoinContext);
        if (optimizedForNonEmpty == null) {
            if (this.context.hasEvaluatedSlicerAndSubSelect()) {
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY on none crossjoin axis (" + axis + ")"));
                optimizedForNonEmpty = new OlapFastCrossjoinIterator(crossjoinContext, List.of(axisTupleIterator), -1);
            } else {
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : fast crossjoin could not be setup"));
                return new OlapCellAxis(axis, true, axisTupleIterator, false, axisTupleDimensionality);
            }
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY setup for axis (" + axis + ")"));
        return new OlapCellAxis(axis, true, optimizedForNonEmpty, true, axisTupleDimensionality);
    }

    private boolean mightHaveCalcMembers(int axis) {
        if (this.mightHaveCalcMembers[axis] == null) {
            this.mightHaveCalcMembers[axis] = this.axisTupleIterators[axis].mightHaveCalcMember();
        }
        return this.mightHaveCalcMembers[axis];
    }

    @Nullable
    private S_NonEmptyBehavior setupNonEmptyBehavior(int axisWithMeasures, int axis) {
        List<OlapMember> measureFromAxes = this.setupMeasuresFromAxisWithMeasures(axisWithMeasures, axis);
        if (measureFromAxes == null) {
            return null;
        }
        for (int ii = 0; ii < this.axisSets.length; ++ii) {
            if (ii == axisWithMeasures || ii == axis || !this.mightHaveCalcMembers(ii)) continue;
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : non-empty-behaviors might have a calc. member"));
            return null;
        }
        return this.setupNonEmptyBehavior(axisWithMeasures, axis, measureFromAxes);
    }

    @Nullable
    private List<OlapMember> setupMeasuresFromAxisWithMeasures(int axisWithMeasures, int axis) {
        if (axisWithMeasures == -1) {
            return Collections.emptyList();
        }
        OlapHierarchy measuresHierarchy = this.context.getMeasuresHierarchy();
        List<OlapMember> measures = this.axisTupleIterators[axisWithMeasures].tryExtractMeasures(measuresHierarchy);
        if (measures != null && !measures.isEmpty()) {
            if (this.hasCalcMeasure(axis, measures)) {
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : non-empty-behaviors [Measures] axis(" + axisWithMeasures + ") contains a calc. member"));
                return null;
            }
            return measures;
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : non-empty-behaviors [Measures] axis(" + axisWithMeasures + ") not determined"));
        return null;
    }

    private boolean hasCalcMeasure(int axis, List<? extends OlapTuple> tuples) {
        for (OlapTuple olapTuple : tuples) {
            OlapMember cm = null;
            for (int ii = 0; ii < olapTuple.getMemberCount(); ++ii) {
                OlapMember member = olapTuple.getMember(ii);
                if (!member.isCalculated()) continue;
                if (!member.isMeasure()) {
                    return true;
                }
                try {
                    S_NonEmptyBehaviorFactoryContext nonEmptyBehaviorContext = this.createNonEmptyBehaviorContext(axis);
                    S_NonEmptyBehavior s_NonEmptyBehavior = S_NonEmptyBehaviorFactory.createForMember(nonEmptyBehaviorContext, member);
                }
                catch (OlapNonEmptyBehaviorException ex) {
                    OlapLoggers.MDX_EVALUATION.warn((Object)("[mdx] could not create the non empty behavior => error : " + ex.getMessage()));
                    return true;
                }
                if (cm != null) {
                    return true;
                }
                cm = member;
            }
        }
        return false;
    }

    private S_NonEmptyBehavior setupNonEmptyBehavior(final int axisWithMeasures, final int axis, final List<OlapMember> measureFromAxes) {
        try {
            ArrayList fakeMembers = new ArrayList();
            for (int ii = 0; ii < this.axisTupleDimensionalities.length; ++ii) {
                if (axisWithMeasures != ii && axis != ii && this.mightHaveCalcMembers(ii)) {
                    OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : axis(" + ii + ") might have calc. member"));
                    return null;
                }
                OlapTupleDimensionality axisTupleDimensionality = this.axisTupleDimensionalities[ii];
                this.context.getSchema().forEachHierarchy(axisTupleDimensionality, (CdActionEx<OlapHierarchy>)((CdActionEx)(idx, hierarchy) -> {
                    if (hierarchy.isMeasures()) {
                        throw new RuntimeException("internal error: unexpected [Measures] hierarchy");
                    }
                    OlapMember fakeAll = hierarchy.getAllMember4Facts();
                    fakeMembers.add(fakeAll);
                    return true;
                }));
            }
            S_NonEmptyBehavior measuresAxisNE = null;
            if (!measureFromAxes.isEmpty()) {
                try {
                    S_NonEmptyBehaviorFactoryContext nonEmptyBehaviorContext = this.createNonEmptyBehaviorContext(axis);
                    measuresAxisNE = S_NonEmptyBehaviorFactory.createForMembers(nonEmptyBehaviorContext, measureFromAxes);
                }
                catch (OlapNonEmptyBehaviorException e) {
                    OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for measure axis (" + axis + ") : completion with calc. measure"));
                    return null;
                }
            }
            OlapTuple[] fakeCell = fakeMembers.toArray(new OlapTuple[fakeMembers.size()]);
            OlapCellsEvaluationContext cellsContext = new OlapCellsEvaluationContext(this.context, this.hasNonEmpty, Collections.emptyList());
            OlapCellEvaluationContext cellContext = new OlapCellEvaluationContext(cellsContext);
            OlapTuple cellTuple = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)this.context, this.context.getTupleDimensionalityCache(), cellContext.getTupleFilter(), fakeCell);
            GFCellsTupleEvaluator cellsTupleEvaluator = new GFCellsTupleEvaluator(cellsContext);
            final MutableObject behaviors = new MutableObject();
            GFCellEvalContext eContext = new GFCellEvalContext(this, cellsTupleEvaluator, cellContext, cellTuple){
                final /* synthetic */ OlapCellProcessorNonEmptyFactory this$0;
                {
                    OlapCellProcessorNonEmptyFactory olapCellProcessorNonEmptyFactory = this$0;
                    Objects.requireNonNull(olapCellProcessorNonEmptyFactory);
                    this.this$0 = olapCellProcessorNonEmptyFactory;
                    super(cellsTupleEvaluator, evalContext, cellTuple);
                }

                @Override
                public OlapScalarEntity computeFactsTupleFromFacts(GFFactsEvalTuple evalTuple) {
                    if (measureFromAxes.isEmpty()) {
                        try {
                            S_NonEmptyBehavior neb = S_NonEmptyBehaviorFactory.createForMeasure(evalTuple.getMeasure());
                            behaviors.setValue((Object)neb);
                        }
                        catch (OlapNonEmptyBehaviorException ex) {
                            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : error w/ tuple: " + String.valueOf(evalTuple)), (Throwable)ex);
                        }
                    } else {
                        try {
                            S_NonEmptyBehaviorFactoryContext nonEmptyBehaviorContext = this.createNonEmptyBehaviorContext();
                            S_NonEmptyBehavior neb = S_NonEmptyBehaviorFactory.createForMembers(nonEmptyBehaviorContext, measureFromAxes);
                            behaviors.setValue((Object)neb);
                        }
                        catch (OlapNonEmptyBehaviorException ex) {
                            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : error w/ tuple: " + String.valueOf(evalTuple)), (Throwable)ex);
                        }
                    }
                    return OlapEmptyEntity.INSTANCE;
                }

                private S_NonEmptyBehaviorFactoryContext createNonEmptyBehaviorContext() {
                    return this.this$0.createNonEmptyBehaviorContext(axis);
                }
            };
            GFCellTupleEvaluator cellEvaluator = new GFCellTupleEvaluator(this, eContext){
                final /* synthetic */ OlapCellProcessorNonEmptyFactory this$0;
                {
                    OlapCellProcessorNonEmptyFactory olapCellProcessorNonEmptyFactory = this$0;
                    Objects.requireNonNull(olapCellProcessorNonEmptyFactory);
                    this.this$0 = olapCellProcessorNonEmptyFactory;
                    super(cellEvalContext);
                }

                @Override
                protected OlapScalarEntity doComputeCalcMemberTuple(GFContext context, GFCalcMemberEvalTuple evalTuple) {
                    evalTuple.forEachCalcOrMeasureOnOrder(member -> {
                        if (axisWithMeasures != -1 && member.isMeasure()) {
                            return true;
                        }
                        try {
                            S_NonEmptyBehaviorFactoryContext nonEmptyBehaviorContext = this.this$0.createNonEmptyBehaviorContext(axis);
                            S_NonEmptyBehavior neb = S_NonEmptyBehaviorFactory.createForMember(nonEmptyBehaviorContext, member);
                            if (neb.isTransparent()) {
                                return true;
                            }
                            behaviors.setValue((Object)neb);
                            return false;
                        }
                        catch (OlapNonEmptyBehaviorException e) {
                            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : completion with calc. member"));
                            return false;
                        }
                    });
                    return OlapEmptyEntity.INSTANCE;
                }
            };
            try {
                cellsTupleEvaluator.init(fakeCell);
                cellEvaluator.getCellValue(eContext, cellTuple);
                return S_NonEmptyBehaviorOperator.merge(measuresAxisNE, (S_NonEmptyBehavior)behaviors.get());
            }
            catch (OlapException ex) {
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : fake eval. error"), (Throwable)((Object)ex));
                return null;
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] fast NON EMPTY disabled for axis (" + axis + ") : fake unexpected error"), (Throwable)ex);
            return null;
        }
    }

    private S_NonEmptyBehaviorFactoryContext createNonEmptyBehaviorContext(int axis) {
        OlapTupleDimensionality dimensionality = this.axisTupleDimensionalities[axis];
        if (dimensionality == null) {
            throw new RuntimeException("internal error: unexpected missing axis [" + axis + "] dimensionality");
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] create NON EMPTY behavior context for axis (" + axis + ") with dimensionality : " + dimensionality.asString(this.context)));
        return this.context.createNonEmptyBehaviorContext(dimensionality);
    }
}

