/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.cells.processor;

import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMeasureVectorMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.result.OlapEvalResultSi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapCellMeasureVectorsPositions {
    private final Map<OlapMember, Integer> initialPositions = new HashMap<OlapMember, Integer>();

    public OlapCellMeasureVectorsPositions(List<OlapTuple> axisMeasures, List<OlapTuple> simplifiedMeasures) {
        for (int ii = 0; ii < axisMeasures.size(); ++ii) {
            OlapMember measure = axisMeasures.get(ii).getMember(0);
            if (this.initialPositions.containsKey(measure)) {
                throw new RuntimeException("internal error: inconsistent measures-vector evaluation");
            }
            this.initialPositions.put(measure, ii);
        }
        for (OlapTuple tuple : simplifiedMeasures) {
            OlapMember simplifiedMeasure = tuple.getMember(0);
            if (simplifiedMeasure instanceof OlapMeasureVectorMember) {
                OlapMeasureVectorMember simplifiedMeasure_ = (OlapMeasureVectorMember)simplifiedMeasure;
                for (OlapMeasureMember measureMember : simplifiedMeasure_.getMeasures()) {
                    Integer initialPosition = this.initialPositions.get(measureMember);
                    if (initialPosition != null) continue;
                    throw new RuntimeException("internal error: inconsistent measures-vector evaluation");
                }
                continue;
            }
            Integer initialPosition = this.initialPositions.get(simplifiedMeasure);
            if (initialPosition != null) continue;
            throw new RuntimeException("internal error: inconsistent measures-vector evaluation");
        }
    }

    public CellInfo adjustCellInformation(OlapEvalResultSi cellSi, OlapTuple[] cellTuples, OlapTuple cellTuple, int pos) {
        OlapEvalResultSi cellSi_ = this.fixCellSi(cellSi, cellTuples, cellTuple, pos);
        OlapTuple[] cellTuples_ = this.fixCellTuples(cellSi, cellTuples, cellTuple, pos);
        OlapTuple cellTuple_ = this.fixCellTuple(cellSi, cellTuples, cellTuple, pos);
        return new CellInfo(cellSi_, cellTuples_, cellTuple_);
    }

    private OlapEvalResultSi fixCellSi(OlapEvalResultSi cellSi, OlapTuple[] cellTuples, OlapTuple cellTuple, int pos) {
        int measuresAxis = -1;
        OlapMember measure = null;
        for (int axis = 0; axis < cellTuples.length; ++axis) {
            MeasureTuple measureTuple = this.getMeasureTuple(cellTuples[axis], pos);
            if (measureTuple == null) continue;
            if (measuresAxis != -1) {
                throw new RuntimeException("internal error: inconsistent measures-vector cell evaluation");
            }
            measuresAxis = axis;
            measure = measureTuple.measure;
        }
        if (measuresAxis == -1 || measure == null) {
            throw new RuntimeException("internal error: inconsistent measures-vector cell evaluation");
        }
        int initialPosition = this.getInitialPosition(measure);
        int[] Si = cellSi.getSi();
        if (Si[measuresAxis] == initialPosition) {
            return cellSi;
        }
        int[] Si_ = new int[Si.length];
        System.arraycopy(Si, 0, Si_, 0, Si.length);
        Si_[measuresAxis] = initialPosition;
        return new OlapEvalResultSi(Si_);
    }

    private OlapTuple[] fixCellTuples(OlapEvalResultSi cellSi, OlapTuple[] cellTuples, OlapTuple cellTuple, int pos) {
        for (int ii = 0; ii < cellTuples.length; ++ii) {
            MeasureTuple measureTuple = this.getMeasureTuple(cellTuples[ii], pos);
            if (measureTuple == null) continue;
            if (!cellTuples[ii].isMeasureVector()) {
                return cellTuples;
            }
            OlapTuple[] cellTuples_ = new OlapTuple[cellTuples.length];
            System.arraycopy(cellTuples, 0, cellTuples_, 0, cellTuples.length);
            cellTuples_[ii] = cellTuples[ii].replace(measureTuple.pos, measureTuple.measure);
            return cellTuples_;
        }
        throw new RuntimeException("internal error: inconsistent measures-vector cell evaluation");
    }

    private OlapTuple fixCellTuple(OlapEvalResultSi cellSi, OlapTuple[] cellTuples, OlapTuple cellTuple, int pos) {
        if (!cellTuple.isMeasureVector()) {
            return cellTuple;
        }
        MeasureTuple measureTuple = this.getMeasureTuple(cellTuple, pos);
        if (measureTuple == null) {
            throw new RuntimeException("internal error: inconsistent measures-vector cell evaluation");
        }
        return cellTuple.replace(measureTuple.pos, measureTuple.measure);
    }

    public int getInitialPosition(OlapMember measure) {
        Integer pos = this.initialPositions.get(measure);
        if (pos == null) {
            throw new RuntimeException("internal error: inconsistent measures-vector cell evaluation");
        }
        return pos;
    }

    @Nullable
    private MeasureTuple getMeasureTuple(OlapTuple tuple, int pos) {
        for (int ii = 0; ii < tuple.getMemberCount(); ++ii) {
            OlapMember member = tuple.getMember(ii);
            if (member instanceof OlapMeasureVectorMember) {
                OlapMeasureVectorMember mcMeasure = (OlapMeasureVectorMember)member;
                List<OlapMeasureMember> measures = mcMeasure.getMeasures();
                return new MeasureTuple(measures.get(pos), ii);
            }
            if (!member.isMeasure()) continue;
            return new MeasureTuple(member, ii);
        }
        return null;
    }

    public List<OlapTuple> adjustAxisTuples(List<OlapTuple> axisTuples) {
        boolean requiresFix = false;
        for (OlapTuple olapTuple : axisTuples) {
            if (!olapTuple.isMeasureVector()) continue;
            requiresFix = true;
            break;
        }
        if (!requiresFix) {
            return axisTuples;
        }
        OlapTuple[] fixedAxisTuples = new OlapTuple[this.initialPositions.size()];
        for (OlapTuple axisTuple : axisTuples) {
            if (axisTuple instanceof OlapMember) {
                if (axisTuple instanceof OlapMeasureVectorMember) {
                    OlapMeasureVectorMember mcMeasure = (OlapMeasureVectorMember)axisTuple;
                    List<OlapMeasureMember> measures = mcMeasure.getMeasures();
                    for (OlapMeasureMember measure : measures) {
                        this.fixAxisTuple(fixedAxisTuples, measure);
                    }
                    continue;
                }
                this.fixAxisTuple(fixedAxisTuples, (OlapMember)axisTuple);
                continue;
            }
            throw new RuntimeException("internal error: inconsistent measures-vector cell evaluation");
        }
        ArrayList<OlapTuple> arrayList = new ArrayList<OlapTuple>();
        for (OlapTuple fixedAxisTuple : fixedAxisTuples) {
            if (fixedAxisTuple == null) {
                throw new RuntimeException("internal error: inconsistent measures-vector cell evaluation");
            }
            arrayList.add(fixedAxisTuple);
        }
        return arrayList;
    }

    private void fixAxisTuple(OlapTuple[] fixedAxisTuples, OlapMember measure) {
        int initialPosition = this.getInitialPosition(measure);
        fixedAxisTuples[initialPosition] = measure;
    }

    public static class CellInfo {
        public final OlapEvalResultSi cellSi;
        public final OlapTuple[] cellTuples;
        public final OlapTuple cellTuple;

        CellInfo(OlapEvalResultSi cellSi, OlapTuple[] cellTuples, OlapTuple cellTuple) {
            this.cellSi = cellSi;
            this.cellTuples = cellTuples;
            this.cellTuple = cellTuple;
        }
    }

    private static class MeasureTuple {
        final OlapMember measure;
        final int pos;

        MeasureTuple(OlapMember measure, int pos) {
            this.measure = measure;
            this.pos = pos;
        }
    }
}

