/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.cells;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.collection.olapiterator.IOlapCombinationIterator;
import java.lang.reflect.Array;
import java.util.List;

public class OlapFactsCellDiagonalIterator<T>
implements IOlapCombinationIterator<T> {
    private final List<T> rows;
    private final List<T> columns;
    private final int[] Si = new int[2];
    private final T[] combination;
    private int __pos;
    private final int sizeR;
    private final int sizeC;
    private final int size;
    private final int maxRC;
    private final int deltaR;
    private final int deltaC;

    public OlapFactsCellDiagonalIterator(Class<T> clazz, List<T> rows, List<T> columns) {
        if (rows.isEmpty()) {
            throw new CdProgrammingException("internal error : unexpected empty rows axis");
        }
        if (columns.isEmpty()) {
            throw new CdProgrammingException("internal error : unexpected empty rows axis");
        }
        this.rows = rows;
        this.columns = columns;
        this.combination = (Object[])Array.newInstance(clazz, 2);
        this.sizeR = rows.size();
        this.sizeC = columns.size();
        this.size = this.sizeR * this.sizeC;
        this.maxRC = Math.max(this.sizeR, this.sizeC);
        this.deltaR = this.sizeR <= this.sizeC ? 1 : 0;
        this.deltaC = this.deltaR == 1 ? 0 : 1;
    }

    @Override
    public int axisCount() {
        return 2;
    }

    @Override
    public List<T> extractAxis(int axis) {
        if (axis == 0) {
            return this.rows;
        }
        if (axis == 1) {
            return this.columns;
        }
        throw new RuntimeException("internal error: inconsistent usage of cell iterator (" + axis + ")");
    }

    @Override
    public boolean isCombination() {
        return false;
    }

    @Override
    public void reset() {
        this.__pos = 0;
    }

    @Override
    public T[] next() {
        if (this.__pos < this.size) {
            int i = this.__pos % this.maxRC;
            int delta = this.__pos / this.maxRC;
            int row = (i + delta * this.deltaR) % this.sizeR;
            int col = (i + delta * this.deltaC) % this.sizeC;
            this.combination[0] = this.rows.get(row);
            this.combination[1] = this.columns.get(col);
            this.Si[0] = row;
            this.Si[1] = col;
            ++this.__pos;
            return this.combination;
        }
        return null;
    }

    @Override
    public int[] Si() {
        return this.Si;
    }
}

