/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.aggregation.table;

import crazydev.iccube.cluster.node.facts.IFactTableContext;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.olap.entity.scalar.OlapErrorEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericFormattedEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericWithUnitEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.OlapTableAggregationException;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactsTableRow;
import org.jetbrains.annotations.Nullable;
import org.joda.time.ReadablePartial;
import org.joda.time.base.AbstractPartial;

public interface IOlapFactTableAggregator
extends N_MeasureGroup.IFactAggregator {
    public String getName();

    public void init(IFactTableContext var1, String var2, String var3);

    public boolean onRow(int var1, IOlapFactsTableRow var2);

    @Override
    @Nullable
    public OlapScalarEntity asScalarEntity();

    default public OlapScalarEntity asError(String errorMessage) {
        return new OlapErrorEntity(new OlapTableAggregationException(errorMessage));
    }

    default public OlapScalarEntity asNumericEntity(double value) {
        return new OlapNumericEntity(value);
    }

    default public OlapScalarEntity asNumericEntityWithUnit(@Nullable Double value, String unit, boolean errorOnMismatch) {
        return value == null ? null : new OlapNumericWithUnitEntity(value, unit, errorOnMismatch);
    }

    default public OlapScalarEntity asNumericEntity(@Nullable Double value) {
        return this.asNumericEntity(value, null);
    }

    default public OlapScalarEntity asNumericEntity(@Nullable Double value, @Nullable String formattedValue) {
        if (value == null && formattedValue == null) {
            return null;
        }
        if (formattedValue == null) {
            return new OlapNumericEntity(value);
        }
        return new OlapNumericFormattedEntity(value == null ? 0.0 : value, formattedValue);
    }

    default public boolean isBefore(AbstractPartial a, AbstractPartial b) {
        return a.isBefore((ReadablePartial)b);
    }

    default public boolean isBeforeOrEqual(AbstractPartial a, AbstractPartial b) {
        return !a.isAfter((ReadablePartial)b);
    }

    default public boolean isAfter(AbstractPartial a, AbstractPartial b) {
        return a.isAfter((ReadablePartial)b);
    }

    default public boolean isAfterOrEqual(AbstractPartial a, AbstractPartial b) {
        return !a.isBefore((ReadablePartial)b);
    }

    default public boolean isInRange(@Nullable AbstractPartial start, @Nullable AbstractPartial end, AbstractPartial test) {
        return !(start != null && !this.isAfterOrEqual(test, start) || end != null && !this.isBeforeOrEqual(test, end));
    }

    default public String getUxInfo() {
        return "";
    }
}

