/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.aggregation.rollup;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.facts.aggregation.rollup.OlapScalarEntityRollupProcessor;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;

public class OlapUnaryOperatorProcessor
extends OlapScalarEntityRollupProcessor {
    public static final String PROPERTY_NAME = "@UO";

    @Override
    protected OlapScalarEntity evalTupleForRollupMember(GFContext context, GFFactsEvalTuple evalTuple, int rollupMemberIdx, OlapMember rollupMember) {
        OlapMember child;
        if (rollupMember.isLeaf()) {
            GFFactsEvalTuple xtuple = evalTuple.replaceMemberForRollup(rollupMemberIdx, rollupMember);
            return this.doEvalTuple(context, xtuple);
        }
        OlapIterator<OlapMember> children = rollupMember.getChildren(context.getMemberFilter());
        children.reset();
        OlapScalarEntity value = OlapEmptyEntity.INSTANCE;
        OlapScalarEntity prevSiblingsSum = OlapEmptyEntity.INSTANCE;
        while ((child = children.next()) != null) {
            String unaryOperator = this.getOperator(child);
            GFFactsEvalTuple xtuple = evalTuple.replaceMemberForRollup(rollupMemberIdx, child);
            OlapScalarEntity childValue = this.evalTupleForRollupMember(context, xtuple, rollupMemberIdx, child);
            switch (unaryOperator.charAt(0)) {
                case '-': {
                    value = OlapScalarOperators.minus(value, childValue);
                    break;
                }
                case '*': {
                    OlapScalarEntity value1 = OlapScalarOperators.multiply(childValue, prevSiblingsSum);
                    value = OlapScalarOperators.sum(value, value1);
                    break;
                }
                case '/': {
                    OlapScalarEntity value1 = OlapScalarOperators.divide(childValue, prevSiblingsSum);
                    value = OlapScalarOperators.sum(value, value1);
                    break;
                }
                case '~': {
                    break;
                }
                default: {
                    value = OlapScalarOperators.sum(value, childValue);
                }
            }
            prevSiblingsSum = OlapScalarOperators.sum(prevSiblingsSum, childValue);
        }
        OlapScalarEntity cValue = value.asNonAggregating(true);
        return cValue;
    }

    private String getOperator(OlapMember child) {
        OlapScalarEntity propValue = child.getUnaryOperator();
        if (propValue == null) {
            return " ";
        }
        String asString = propValue.asString();
        if (asString.isEmpty()) {
            return " ";
        }
        return asString;
    }
}

