/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.aggregation;

import crazydev.iccube.cluster.node.facts.N_AggregatorHelper;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapCountAggrEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import java.util.Arrays;

public class OlapFactsEntityAggregators {
    private static final OlapFactsEntityAggregator[] REGULAR_AGGREGATORS = new OlapFactsEntityAggregator[OlapAggregationType.values().length + 1];
    private static final OlapFactsEntityAggregator MEASURE_VECTOR_AGGREGATOR = new OlapFactsMeasureVectorEntityAggregator();

    public static OlapFactsEntityAggregator regularEntityAggregator(OlapAggregationType aggregationType) {
        OlapFactsEntityAggregator aggregator = REGULAR_AGGREGATORS[aggregationType.ordinal()];
        return aggregator;
    }

    public static OlapFactsEntityAggregator measureVectorEntityAggregator() {
        return MEASURE_VECTOR_AGGREGATOR;
    }

    static {
        Arrays.fill(REGULAR_AGGREGATORS, new OlapFactsNotSupportedEntityAggregator());
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.SUM.ordinal()] = new OlapFactsDefaultEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.SUM_HIGH_PRECISION.ordinal()] = new OlapFactsDefaultEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.MIN.ordinal()] = new OlapFactsDefaultEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.MAX.ordinal()] = new OlapFactsDefaultEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.AVG_LEAVES.ordinal()] = new OlapFactsDefaultEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.DISTINCT_COUNT.ordinal()] = new OlapFactsDefaultEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.SUM_SQUARE.ordinal()] = new OlapFactsDefaultEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.VECTOR.ordinal()] = new OlapFactsDefaultEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.VECTOR_SORTED.ordinal()] = new OlapFactsDefaultEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.VECTOR_UNIQUE.ordinal()] = new OlapFactsDefaultEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.VECTOR_ROW_NUMBER.ordinal()] = new OlapFactsDefaultEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.TABLE_ROW_NUMBER.ordinal()] = new OlapFactsDefaultEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.OPEN.ordinal()] = new OlapFactsSumEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.CLOSE.ordinal()] = new OlapFactsSumEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.OPEN_NO_EMPTY.ordinal()] = new OlapFactsSumEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.CLOSE_NO_EMPTY.ordinal()] = new OlapFactsSumEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.AVG_CHILDREN.ordinal()] = new OlapFactsSumEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.SUM_CHILDREN.ordinal()] = new OlapFactsSumEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.UNARY_OPERATOR.ordinal()] = new OlapFactsSumEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.COUNT.ordinal()] = new OlapFactsCountEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.NO_EMPTY.ordinal()] = new OlapFactsNoEmptyEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.NO_EMPTY_ROWS.ordinal()] = new OlapFactsNoEmptyRowsEntityAggregator();
        OlapFactsEntityAggregators.REGULAR_AGGREGATORS[OlapAggregationType.NONE.ordinal()] = new OlapFactsNoneEntityAggregator();
    }

    public static abstract class OlapFactsEntityAggregator {
        public boolean isDefault() {
            return false;
        }

        public final OlapScalarEntity aggregate(N_AggregatorHelper helper) {
            OlapScalarEntity scalar = this.doAggregate(helper);
            OlapScalarEntity res = helper.toEmptyZeroIfNeeded(scalar);
            return res;
        }

        protected abstract OlapScalarEntity doAggregate(N_AggregatorHelper var1);
    }

    private static final class OlapFactsMeasureVectorEntityAggregator
    extends OlapFactsEntityAggregator {
        private OlapFactsMeasureVectorEntityAggregator() {
        }

        @Override
        public OlapScalarEntity doAggregate(N_AggregatorHelper helper) {
            OlapAggregationType aggregationType = helper.getAggregationType();
            if (!aggregationType.isSum()) {
                throw new RuntimeException("internal error: inconsistent measures-vector processing [" + aggregationType.name() + "]");
            }
            OlapScalarEntity res = helper.aggregate(aggregationType);
            return res;
        }
    }

    private static final class OlapFactsNotSupportedEntityAggregator
    extends OlapFactsEntityAggregator {
        private OlapFactsNotSupportedEntityAggregator() {
        }

        @Override
        public OlapScalarEntity doAggregate(N_AggregatorHelper helper) {
            OlapAggregationType type = helper.getAggregationType();
            String measureName = helper.getMeasureName();
            throw new RuntimeException("internal error: the aggregation type [" + String.valueOf((Object)type) + "] is not supported (measure : " + measureName + ")");
        }
    }

    private static final class OlapFactsDefaultEntityAggregator
    extends OlapFactsEntityAggregator {
        private OlapFactsDefaultEntityAggregator() {
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public OlapScalarEntity doAggregate(N_AggregatorHelper helper) {
            OlapAggregationType aggregationType = helper.getAggregationType();
            OlapScalarEntity res = helper.aggregate(aggregationType);
            return res;
        }
    }

    private static final class OlapFactsSumEntityAggregator
    extends OlapFactsEntityAggregator {
        private OlapFactsSumEntityAggregator() {
        }

        @Override
        public OlapScalarEntity doAggregate(N_AggregatorHelper helper) {
            OlapScalarEntity res = helper.aggregate(OlapAggregationType.SUM);
            return res;
        }
    }

    private static final class OlapFactsCountEntityAggregator
    extends OlapFactsEntityAggregator {
        private OlapFactsCountEntityAggregator() {
        }

        @Override
        public OlapScalarEntity doAggregate(N_AggregatorHelper helper) {
            if (helper.isDrillthroughActive() || helper.hasNulls()) {
                OlapScalarEntity res = helper.aggregate(OlapAggregationType.COUNT);
                return res;
            }
            long count = helper.cardinality();
            OlapAbstractScalarEntity res = count == 0L ? OlapEmptyEntity.INSTANCE : new OlapCountAggrEntity(count);
            return res;
        }
    }

    private static final class OlapFactsNoEmptyEntityAggregator
    extends OlapFactsEntityAggregator {
        private OlapFactsNoEmptyEntityAggregator() {
        }

        @Override
        public OlapScalarEntity doAggregate(N_AggregatorHelper helper) {
            if (helper.isDrillthroughActive() || helper.hasNulls()) {
                OlapScalarEntity res = helper.aggregate(OlapAggregationType.NO_EMPTY);
                return res;
            }
            boolean noEmpty = helper.isNoEmpty();
            OlapScalarEntity res = OlapEmptyEntity.asEmpty(!noEmpty);
            return res;
        }
    }

    private static final class OlapFactsNoEmptyRowsEntityAggregator
    extends OlapFactsEntityAggregator {
        private OlapFactsNoEmptyRowsEntityAggregator() {
        }

        @Override
        public OlapScalarEntity doAggregate(N_AggregatorHelper helper) {
            if (helper.isDrillthroughActive()) {
                OlapScalarEntity res = helper.aggregate(OlapAggregationType.NO_EMPTY_ROWS);
                return res;
            }
            boolean noEmpty = helper.isNoEmpty();
            OlapScalarEntity res = OlapEmptyEntity.asEmpty(!noEmpty);
            return res;
        }
    }

    private static final class OlapFactsNoneEntityAggregator
    extends OlapFactsEntityAggregator {
        private OlapFactsNoneEntityAggregator() {
        }

        @Override
        public OlapScalarEntity doAggregate(N_AggregatorHelper helper) {
            long cardinality = helper.cardinality();
            if (cardinality != 1L) {
                if (helper.isDrillthroughActive()) {
                    OlapScalarEntity olapScalarEntity = helper.aggregate(OlapAggregationType.SUM);
                }
                return OlapEmptyEntity.INSTANCE;
            }
            OlapScalarEntity res = helper.aggregate(OlapAggregationType.SUM);
            return res;
        }
    }
}

