/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.aggregation;

public abstract class OlapFactsBufferingCallback {
    private final int[] buffer = new int[1024];
    private int offset;

    public final void onRange(int startRowId, int endRowId) {
        if (this.offset > 0) {
            this.doOnPoints(this.buffer, this.offset);
            this.offset = 0;
        }
        this.doOnRange(startRowId, endRowId);
    }

    public final void onPoint(int rowId) {
        if (this.offset < this.buffer.length) {
            this.buffer[this.offset++] = rowId;
        } else {
            this.doOnPoints(this.buffer, this.offset);
            this.buffer[0] = rowId;
            this.offset = 1;
        }
    }

    public final void onApplied() {
        if (this.offset > 1) {
            this.doOnPoints(this.buffer, this.offset);
        } else if (this.offset > 0) {
            this.doOnPoint(this.buffer[0]);
        }
        this.offset = 0;
    }

    protected abstract void doOnRange(int var1, int var2);

    protected abstract void doOnPoints(int[] var1, int var2);

    protected abstract void doOnPoint(int var1);
}

