/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator;

import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapBlankTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFTupleNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFGeneralLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GFNonEmptyGeneralLambdaTupleEvaluator
extends GFGeneralLambdaTupleEvaluator {
    private boolean set2init;
    @Nullable
    private OlapTupleSet<? extends OlapTuple> set2;

    public GFNonEmptyGeneralLambdaTupleEvaluator(OlapProperties properties, GFTupleEvaluator other, GFApplyLambdaNode lambdaNode, double fastEstimatedSize) {
        super(properties, other, lambdaNode, fastEstimatedSize);
    }

    @Override
    protected OlapEntity evalLambdaForLambdaTuple(GFContext context, GFMiniTupleEvaluator miniTupleEvaluator, GFNode lambda) {
        if (this.set2init) {
            if (this.set2 == null) {
                OlapEntity evaluatedLambda = this.evalLambdaX(context, miniTupleEvaluator, lambda);
                return evaluatedLambda;
            }
            OlapEntity evaluatedLambda = this.doEvalLambdaForSet2(context, miniTupleEvaluator);
            return evaluatedLambda;
        }
        OlapEntity evaluatedLambda = this.evalLambdaForLambdaTupleInit(context, miniTupleEvaluator, lambda);
        return evaluatedLambda;
    }

    @Override
    protected OlapEntity evalLambdaForBlankTuple(GFContext context, GFMiniTupleEvaluator miniTupleEvaluator) {
        OlapScalarEntity evaluatedLambda = miniTupleEvaluator.getValueForNonEmpty(context, OlapBlankTuple.INSTANCE);
        return evaluatedLambda;
    }

    private OlapEntity evalLambdaX(GFContext context, GFMiniTupleEvaluator miniTupleEvaluator, GFNode lambda) {
        if (lambda instanceof GFTupleNode && lambda.isMarkedForValueEvaluation()) {
            GFTupleNode tNode = (GFTupleNode)lambda;
            OlapTuple tuple = tNode.getTuple();
            OlapScalarEntity evaluatedLambda = miniTupleEvaluator.getValueForNonEmpty(context, tuple);
            return evaluatedLambda;
        }
        OlapEntity evaluatedLambda = lambda.execute(context, miniTupleEvaluator);
        if (evaluatedLambda.isMdxNull()) {
            return OlapEmptyEntity.INSTANCE;
        }
        if (evaluatedLambda instanceof OlapTupleSet) {
            return evaluatedLambda;
        }
        if (evaluatedLambda instanceof OlapTuple) {
            OlapScalarEntity res = miniTupleEvaluator.getValueForNonEmpty(context, (OlapTuple)evaluatedLambda);
            return res;
        }
        if (evaluatedLambda.isToValueApplicable(context, miniTupleEvaluator)) {
            OlapScalarEntity res = evaluatedLambda.toValue(context, miniTupleEvaluator);
            return this.isNoEmpty(res);
        }
        return this.isNoEmpty(evaluatedLambda);
    }

    private OlapScalarEntity isNoEmpty(OlapEntity value) {
        return !value.isMdxNull() ? OlapNumericEntity.ONE_AS_LONG : OlapEmptyEntity.INSTANCE;
    }

    private OlapEntity evalLambdaForLambdaTupleInit(GFContext context, GFMiniTupleEvaluator miniTupleEvaluator, GFNode lambda) {
        this.set2init = true;
        OlapEntity evaluatedLambda = this.evalLambdaX(context, miniTupleEvaluator, lambda);
        if (evaluatedLambda instanceof OlapTupleSet) {
            this.set2 = (OlapTupleSet)evaluatedLambda;
            evaluatedLambda = this.doEvalLambdaForSet2(context, miniTupleEvaluator);
        }
        return evaluatedLambda;
    }

    private OlapEntity doEvalLambdaForSet2(GFContext context, GFMiniTupleEvaluator miniTupleEvaluator) {
        List<? extends OlapTuple> tuples = this.set2.asTupleList().getTuples();
        for (int ii = 0; ii < tuples.size(); ++ii) {
            OlapTuple tuple = tuples.get(ii);
            if (miniTupleEvaluator.getValueForNonEmpty(context, tuple).isMdxNull()) continue;
            return OlapNumericEntity.ONE_AS_LONG;
        }
        return OlapEmptyEntity.INSTANCE;
    }
}

