/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator;

import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapMemberOrigin;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTuple;
import org.jetbrains.annotations.Nullable;

public class GFMiniTupleEvaluatorInitialContext {
    private final GFEvalTuple evalTuple;
    @Nullable
    private final OlapCalculatedMember[] cMembers;
    @Nullable
    private final OlapMemberOrigin[] cMembersOrigin;

    public GFMiniTupleEvaluatorInitialContext(GFEvalTuple evalTuple) {
        OlapMember member;
        int ii;
        int evalTupleSize;
        this.evalTuple = evalTuple;
        int cmCount = 0;
        if (evalTuple.getHighestPriorityMember() != null) {
            evalTupleSize = evalTuple.getMemberCount();
            for (ii = 0; ii < evalTupleSize; ++ii) {
                member = evalTuple.getMember(ii);
                if (!member.isCalculated()) continue;
                ++cmCount;
            }
        }
        if (cmCount > 0) {
            this.cMembers = new OlapCalculatedMember[cmCount];
            this.cMembersOrigin = new OlapMemberOrigin[cmCount];
            cmCount = 0;
            evalTupleSize = evalTuple.getMemberCount();
            for (ii = 0; ii < evalTupleSize; ++ii) {
                member = evalTuple.getMember(ii);
                if (!member.isCalculated()) continue;
                OlapMemberOrigin memberOrigin = evalTuple.getMemberOrigin(ii);
                this.cMembers[cmCount] = (OlapCalculatedMember)member;
                this.cMembersOrigin[cmCount] = memberOrigin;
                ++cmCount;
            }
        } else {
            this.cMembers = null;
            this.cMembersOrigin = null;
        }
    }

    public GFEvalTuple getEvalTuple() {
        return this.evalTuple;
    }

    public int getCalcMemberCount() {
        return this.cMembers != null ? this.cMembers.length : 0;
    }

    public OlapCalculatedMember getCalcMember(int pos) {
        return this.cMembers[pos];
    }

    public OlapMemberOrigin getCalcMemberOrigin(int pos) {
        return this.cMembersOrigin[pos];
    }
}

