/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator;

import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class GFMiniTupleEvaluatorCache {
    private static final int MAX_SIZE = 10000;
    private final Map<OlapTuple, OlapScalarEntity> calcValues = new HashMap<OlapTuple, OlapScalarEntity>();
    private final Map<OlapTuple, OlapScalarEntity> factsValues = new HashMap<OlapTuple, OlapScalarEntity>();
    private final Map<OlapTuple, OlapScalarEntity> factsValuesNE = new HashMap<OlapTuple, OlapScalarEntity>();
    private int size;

    public void clear() {
        this.calcValues.clear();
        this.factsValues.clear();
        this.factsValuesNE.clear();
        this.size = 0;
    }

    @Nullable
    public OlapScalarEntity getCalcValue(OlapTuple miniTuple) {
        OlapScalarEntity res = this.calcValues.get(miniTuple);
        return res;
    }

    public void putCalcValue(OlapTuple miniTuple, OlapScalarEntity value) {
        if (this.size < 10000) {
            this.calcValues.put(miniTuple, value.asConstant());
            ++this.size;
        }
    }

    @Nullable
    public OlapScalarEntity getFactsValue(boolean noEmptyEvaluation, OlapTuple miniTuple) {
        if (!noEmptyEvaluation) {
            OlapScalarEntity res = this.factsValues.get(miniTuple);
            return res;
        }
        OlapScalarEntity res = this.factsValuesNE.get(miniTuple);
        return res;
    }

    public void putFactsValue(boolean noEmptyEvaluation, OlapTuple miniTuple, OlapScalarEntity value) {
        if (this.size < 10000) {
            if (!noEmptyEvaluation) {
                this.factsValues.put(miniTuple, value.asConstant());
            } else {
                this.factsValuesNE.put(miniTuple, value.asConstant());
            }
            ++this.size;
        }
    }

    @Nullable
    public OlapScalarEntity getValue(boolean noEmptyEvaluation, OlapTuple miniTuple) {
        if (!noEmptyEvaluation) {
            OlapScalarEntity res = this.factsValues.get(miniTuple);
            return res;
        }
        OlapScalarEntity res = this.factsValuesNE.get(miniTuple);
        return res;
    }
}

