/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator;

import crazydev.common.utils.CdMutableBoolean;
import crazydev.iccube.collection.OlapStack;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapBlankTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapMemberOrigin;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.cache.GFCacheUtils;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCacheKey;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.GFMiniTupleEvaluationFrame;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFCalcMemberEvalNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFAbstractTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluatorCache;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluatorInitialContext;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class GFMiniTupleEvaluator
extends GFAbstractTupleEvaluator<GFTupleEvaluator> {
    public static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    private final int debug__ = NEXT_ID.incrementAndGet();
    @Nullable
    private final GFNode owner;
    @Nullable
    private final GFMiniTupleEvaluator parentMiniTupleEvaluator;
    private final int parentMiniTupleEvaluatorStackSize;
    private final GFMiniTupleEvaluatorCache cachedTupleValues = new GFMiniTupleEvaluatorCache();
    private final OlapStack<GFMiniTupleEvaluationFrame> miniTupleEvaluationFrames = new OlapStack();
    private GFMiniTupleEvaluator miniTupleEvaluatorI;
    private GFMiniTupleEvaluatorInitialContext contextI;
    @Nullable
    private OlapTuple iTuple;
    @Nullable
    private OlapCalculatedMember[] iTupleCalcMembers;
    private OlapMemberOrigin mcHighestCalcMemberOrigin;
    private OlapCalculatedMember mcHighestCalcMember;

    public GFMiniTupleEvaluator(@Nullable GFNode owner, GFTupleEvaluator other) {
        super(other);
        this.owner = owner;
        this.parentMiniTupleEvaluator = other.resolveMiniTupleEvaluator();
        this.parentMiniTupleEvaluatorStackSize = this.parentMiniTupleEvaluator != null ? this.parentMiniTupleEvaluator.miniTupleStackSizeR() : 0;
    }

    @Override
    public boolean isAcceptingParallelLambdaProcessing() {
        return false;
    }

    @Override
    protected GFMiniTupleEvaluator resolveMiniTupleEvaluator() {
        return this;
    }

    public void onRootCalcMemberEvalStarted(GFContext context) {
        this.miniTupleEvaluatorI = context.pushMiniTupleEvaluator(this);
        GFEvalTuple evalTupleI = context.setupEvalTuple(false, false, OlapBlankTuple.INSTANCE);
        this.contextI = new GFMiniTupleEvaluatorInitialContext(evalTupleI);
    }

    public void onIteratedTupleEvaluation(GFContext context, OlapTuple iTuple) {
        OlapMember member;
        int ii;
        this.cachedTupleValues.clear();
        int cmCount = 0;
        int iTupleSize = iTuple.getMemberCount();
        for (ii = 0; ii < iTupleSize; ++ii) {
            member = iTuple.getMember(ii);
            if (!member.isCalculated()) continue;
            ++cmCount;
        }
        if (cmCount > 0) {
            this.iTupleCalcMembers = new OlapCalculatedMember[cmCount];
            cmCount = 0;
            for (ii = 0; ii < iTupleSize; ++ii) {
                member = iTuple.getMember(ii);
                if (!member.isCalculated()) continue;
                this.iTupleCalcMembers[cmCount] = (OlapCalculatedMember)member;
                ++cmCount;
            }
        } else {
            this.iTupleCalcMembers = null;
        }
        this.iTuple = iTuple;
    }

    public void onRootCalcMemberEvalCompleted(GFContext context) {
        context.popMiniTupleEvaluator(this.miniTupleEvaluatorI);
    }

    @Override
    public OlapScalarEntity getValue(GFContext context, OlapTuple tuple, boolean noEmptyEvaluation) {
        if (tuple.isKO()) {
            return OlapEmptyEntity.INSTANCE;
        }
        GFMiniTupleEvaluationFrame miniTupleF = this.miniComplete(context, tuple, noEmptyEvaluation);
        if (!miniTupleF.isCalcMember()) {
            OlapScalarEntity value = this.getFactsValue(context, miniTupleF);
            return value;
        }
        OlapScalarEntity value = this.getCalcValue(context, miniTupleF);
        return value;
    }

    private OlapScalarEntity getFactsValue(GFContext context, GFMiniTupleEvaluationFrame miniTupleF) {
        boolean noEmptyEvaluation = miniTupleF.noEmptyEvaluation();
        OlapTuple miniTuple = miniTupleF.miniTuple();
        OlapScalarEntity value = this.getFactsValue(context, miniTuple, noEmptyEvaluation);
        return value;
    }

    private OlapScalarEntity getCalcValue(GFContext context, GFMiniTupleEvaluationFrame miniTupleF) {
        OlapTuple miniTuple = miniTupleF.miniTuple();
        OlapScalarEntity value = this.getCalcValue(context, miniTuple, () -> this.getCalcValue_(context, miniTupleF));
        return value;
    }

    @Override
    public OlapScalarEntity getCalcValue(GFContext context, OlapTuple miniTuple, Supplier<OlapScalarEntity> supplier) {
        if (this.isForParent(miniTuple)) {
            OlapScalarEntity value = this.other.getCalcValueFromParent(context, miniTuple, supplier);
            return value;
        }
        OlapScalarEntity value = supplier.get();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapScalarEntity getCalcValue_(GFContext context, GFMiniTupleEvaluationFrame miniTupleF) {
        miniTupleF.computed = false;
        OlapTuple miniTuple = miniTupleF.miniTuple();
        OlapScalarEntity value = this.cachedTupleValues.getCalcValue(miniTuple);
        if (value == null) {
            value = this.isWithGlobalCache(context, miniTupleF) ? this.getCalcValueFromStatementCache(context, miniTupleF, () -> this.computeCalcValue(context, miniTupleF)) : this.computeCalcValue(context, miniTupleF);
            this.cachedTupleValues.putCalcValue(miniTuple, value);
        }
        if (miniTupleF.computed && GFCacheUtils.ASSERT_CONSISTENCY) {
            context.freezeStats();
            try {
                OlapScalarEntity computedValue = this.computeCalcValue(context, miniTupleF);
                GFCacheUtils.assertCachedValue(String.valueOf(miniTupleF) + " [iT] " + String.valueOf(this.iTuple) + " [iC] " + String.valueOf(this.contextI.getEvalTuple()), value, computedValue);
            }
            finally {
                context.unfreezeStats();
            }
        }
        return value;
    }

    private boolean isWithGlobalCache(GFContext context, GFMiniTupleEvaluationFrame miniTupleF) {
        OlapCalculatedMember calcMember = miniTupleF.calcMember();
        if (this.cells != null && calcMember != null) {
            boolean withGlobalCache = this.cells.isWithGlobalCache(context, calcMember);
            return withGlobalCache;
        }
        return false;
    }

    private OlapScalarEntity getCalcValueFromStatementCache(GFContext context, GFMiniTupleEvaluationFrame miniTupleF, Supplier<OlapScalarEntity> supplier) {
        GFCalcTupleCacheKey cacheKey = miniTupleF.createCalcTupleCacheKey(context, this.contextI, this.iTuple);
        OlapScalarEntity value = this.computeCalcTupleFromStatementCache(context, cacheKey, supplier);
        return value;
    }

    private OlapScalarEntity computeCalcValue(GFContext context, GFMiniTupleEvaluationFrame miniTupleF) {
        miniTupleF.computed = true;
        this.pushMiniTupleFrame(context, miniTupleF);
        OlapScalarEntity res = GFCalcMemberEvalNode.evaluate(context, this, miniTupleF);
        this.popMiniTupleFrame();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OlapScalarEntity getFactsValue(GFContext context, OlapTuple miniTuple, boolean noEmptyEvaluation) {
        if (this.isForParent(miniTuple)) {
            OlapScalarEntity value = this.other.getFactsValueFromParent(context, miniTuple, noEmptyEvaluation);
            return value;
        }
        OlapScalarEntity value = this.cachedTupleValues.getFactsValue(noEmptyEvaluation, miniTuple);
        if (value == null) {
            value = this.other.getFactsValue(context, miniTuple, noEmptyEvaluation);
            this.cachedTupleValues.putFactsValue(noEmptyEvaluation, miniTuple, value);
        } else if (GFCacheUtils.ASSERT_CONSISTENCY) {
            context.freezeStats();
            try {
                OlapScalarEntity computedValue = this.other.getFactsValue(context, miniTuple, noEmptyEvaluation);
                GFCacheUtils.assertCachedValue(String.valueOf(miniTuple) + " [iT] " + String.valueOf(this.iTuple) + " [iC] " + String.valueOf(this.contextI.getEvalTuple()), value, computedValue);
            }
            finally {
                context.unfreezeStats();
            }
        }
        return value;
    }

    private boolean isForParent(OlapTuple miniTuple) {
        return this.iTuple != null && this.iTuple.isInTupleDim(miniTuple);
    }

    private GFMiniTupleEvaluationFrame miniComplete(GFContext context, OlapTuple rawTuple, boolean noEmptyEvaluation) {
        OlapTupleDimensionality miniTupleD;
        this.mcHighestCalcMember = null;
        this.mcHighestCalcMemberOrigin = null;
        GFMiniTupleEvaluationFrame miniTupleF = this.peekMiniTupleFrame();
        OlapTuple miniTuple = miniTupleF != null ? miniTupleF.miniTuple() : null;
        OlapTupleDimensionality olapTupleDimensionality = miniTupleD = miniTuple != null ? miniTuple.getTupleDimensionality() : null;
        if (miniTupleD == null || miniTupleD.isIn(rawTuple.getTupleDimensionality())) {
            GFMiniTupleEvaluationFrame frame = this.miniCompleteWithoutCurrentMiniTuple(context, rawTuple, noEmptyEvaluation);
            return frame;
        }
        GFMiniTupleEvaluationFrame frame = this.miniCompleteWithCurrentMiniTuple(context, rawTuple, noEmptyEvaluation, miniTupleF, miniTuple, miniTupleD);
        return frame;
    }

    private GFMiniTupleEvaluationFrame miniCompleteWithoutCurrentMiniTuple(GFContext context, OlapTuple rawTuple, boolean noEmptyEvaluation) {
        OlapTupleDimensionality rawTupleD = rawTuple.getTupleDimensionality();
        OlapMemberOrigin rawTupleOrigin = GFMiniTupleEvaluator.rawTupleOrigin(context);
        ArrayList<OlapMemberOrigin> memberOrigins = new ArrayList<OlapMemberOrigin>();
        int rawTupleS = rawTuple.getMemberCount();
        for (int ii = 0; ii < rawTupleS; ++ii) {
            memberOrigins.add(rawTupleOrigin);
            OlapMember member = rawTuple.getMember(ii);
            if (!member.isCalculated()) continue;
            this.resolveCalcMember(context, (OlapCalculatedMember)member, rawTupleOrigin);
        }
        this.miniCompleteCalcMember(context, rawTupleD, null);
        return new GFMiniTupleEvaluationFrame(this.debug__, noEmptyEvaluation, memberOrigins, rawTuple, this.mcHighestCalcMemberOrigin, this.mcHighestCalcMember);
    }

    private GFMiniTupleEvaluationFrame miniCompleteWithCurrentMiniTuple(GFContext context, OlapTuple rawTuple, boolean noEmptyEvaluation, GFMiniTupleEvaluationFrame miniTupleF, OlapTuple miniTuple, OlapTupleDimensionality miniTupleD) {
        OlapTuple miniTupleC;
        OlapTupleDimensionality rawTupleD = rawTuple.getTupleDimensionality();
        OlapMemberOrigin rawTupleOrigin = GFMiniTupleEvaluator.rawTupleOrigin(context);
        ArrayList<OlapMemberOrigin> memberOrigins = new ArrayList<OlapMemberOrigin>();
        ArrayList<OlapMember> members = new ArrayList<OlapMember>();
        int rawTupleS = rawTuple.getMemberCount();
        for (int ii = 0; ii < rawTupleS; ++ii) {
            memberOrigins.add(rawTupleOrigin);
            OlapMember member = rawTuple.getMember(ii);
            members.add(member);
            if (!member.isCalculated()) continue;
            this.resolveCalcMember(context, (OlapCalculatedMember)member, rawTupleOrigin);
        }
        int miniTupleS = miniTupleF.getMemberCount_();
        for (int ii = 0; ii < miniTupleS; ++ii) {
            OlapMember member = miniTupleF.getMember_(ii);
            OlapHierarchy hierarchy = member.getHierarchy();
            if (rawTupleD.isIn(hierarchy)) continue;
            OlapMemberOrigin origin = miniTupleF.getMemberOrigin_(ii);
            memberOrigins.add(origin);
            members.add(member);
            if (!member.isCalculated()) continue;
            this.resolveCalcMember(context, (OlapCalculatedMember)member, origin);
        }
        this.miniCompleteCalcMember(context, rawTupleD, miniTupleD);
        if (members.isEmpty()) {
            miniTupleC = OlapBlankTuple.INSTANCE;
        } else {
            miniTupleC = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)context, context.getTupleDimensionalityCache(), null, members);
            if (miniTupleC.isKO()) {
                throw new RuntimeException("internal error: invalid completed tuple >> " + String.valueOf(rawTuple));
            }
        }
        return new GFMiniTupleEvaluationFrame(this.debug__, noEmptyEvaluation, memberOrigins, miniTupleC, this.mcHighestCalcMemberOrigin, this.mcHighestCalcMember);
    }

    private static OlapMemberOrigin rawTupleOrigin(GFContext context) {
        boolean inCalcMemberEvaluation = context.isInCalcMemberEvaluation();
        OlapMemberOrigin origin = inCalcMemberEvaluation ? OlapMemberOrigin.CALC_MEMBER : OlapMemberOrigin.OTHER;
        return origin;
    }

    private void miniCompleteCalcMember(GFContext context, OlapTupleDimensionality rawTupleD, @Nullable OlapTupleDimensionality miniTupleD) {
        if (this.iTupleCalcMembers != null) {
            for (int ii = 0; ii < this.iTupleCalcMembers.length; ++ii) {
                OlapCalculatedMember member = this.iTupleCalcMembers[ii];
                OlapHierarchy hierarchy = member.getHierarchy();
                if (rawTupleD.isIn(hierarchy) || miniTupleD != null && miniTupleD.isIn(hierarchy)) continue;
                this.resolveCalcMember(context, member, OlapMemberOrigin.I_TUPLE);
            }
        }
        OlapTupleDimensionality iTupleD = this.iTuple != null ? this.iTuple.getTupleDimensionality() : null;
        int calcMemberCount = this.contextI.getCalcMemberCount();
        for (int ii = 0; ii < calcMemberCount; ++ii) {
            OlapCalculatedMember member = this.contextI.getCalcMember(ii);
            OlapHierarchy hierarchy = member.getHierarchy();
            if (rawTupleD.isIn(hierarchy) || miniTupleD != null && miniTupleD.isIn(hierarchy) || iTupleD != null && iTupleD.isIn(hierarchy)) continue;
            this.resolveCalcMember(context, member, this.contextI.getCalcMemberOrigin(ii));
        }
    }

    private void resolveCalcMember(GFContext context, OlapCalculatedMember member, OlapMemberOrigin memberOrigin) {
        if (this.mcHighestCalcMember != null) {
            this.mcHighestCalcMember = OlapCalculatedMember.highestPriorityMember(context.getEvalContext(), this.mcHighestCalcMember, member);
            if (OlapMember.equal(this.mcHighestCalcMember, member)) {
                this.mcHighestCalcMemberOrigin = memberOrigin;
            }
        } else {
            this.mcHighestCalcMember = member;
            this.mcHighestCalcMemberOrigin = memberOrigin;
        }
    }

    public boolean processMiniTupleEvaluationFrames(OlapStack.Processor<GFMiniTupleEvaluationFrame> processor) {
        return this.miniTupleEvaluationFrames.process(processor);
    }

    public void pushMiniTupleFrame(GFContext context, GFMiniTupleEvaluationFrame frame) {
        OlapTuple miniTuple = frame.miniTuple();
        if (miniTuple.isInvalid()) {
            throw new RuntimeException("internal error: inconsistent tuple evaluation (invalid mini-tuple)");
        }
        this.miniTupleEvaluationFrames.push(frame);
        OlapCalculatedMember calcMember = frame.calcMember();
        if (calcMember != null) {
            context.assertNoCalcMemberCycleX(calcMember);
        }
    }

    public void popMiniTupleFrame() {
        this.miniTupleEvaluationFrames.pop();
    }

    @Nullable
    public GFMiniTupleEvaluationFrame peekMiniTupleFrame() {
        if (this.miniTupleEvaluationFrames.isEmpty()) {
            return null;
        }
        return this.miniTupleEvaluationFrames.peek();
    }

    @Nullable
    public OlapTuple peekMiniTuple() {
        GFMiniTupleEvaluationFrame frame = this.peekMiniTupleFrame();
        OlapTuple tuple = frame != null ? frame.miniTuple() : null;
        return tuple;
    }

    public int miniTupleStackSizeR() {
        int size = this.miniTupleEvaluationFrames.size();
        if (this.parentMiniTupleEvaluator == this.miniTupleEvaluatorI) {
            return size + this.parentMiniTupleEvaluatorStackSize;
        }
        if (this.miniTupleEvaluatorI != null) {
            return size + this.miniTupleEvaluatorI.miniTupleStackSizeR();
        }
        return size;
    }

    public void computeCalcMemberCycleR(List<OlapCalculatedMember> cycle) {
        CdMutableBoolean hasCycle = new CdMutableBoolean();
        this.miniTupleEvaluationFrames.process(frame -> {
            OlapCalculatedMember calcMember = frame.calcMember();
            if (calcMember != null) {
                if (cycle.contains(calcMember)) {
                    cycle.add(calcMember);
                    hasCycle.value = true;
                    return false;
                }
                cycle.add(calcMember);
            }
            return true;
        });
        if (hasCycle.value) {
            return;
        }
        if (this.miniTupleEvaluatorI != null) {
            this.miniTupleEvaluatorI.computeCalcMemberCycleR(cycle);
        }
    }

    @Nullable
    public GFMiniTupleEvaluationFrame mark() {
        return this.miniTupleEvaluationFrames.mark();
    }

    public void resetToMark(@Nullable GFMiniTupleEvaluationFrame mark) {
        this.miniTupleEvaluationFrames.resetToMark(mark);
    }

    public boolean isInCalcMemberEvaluation() {
        boolean inCalcMember = this.miniTupleEvaluationFrames.processB(frame -> frame.calcMember() != null);
        return inCalcMember;
    }

    public String toString() {
        return "" + this.debug__;
    }
}

