/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapBlankTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.GFTupleEvaluationFrame;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFAbstractTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import org.jetbrains.annotations.Nullable;

public abstract class GFLambdaTupleEvaluator
extends GFAbstractTupleEvaluator<GFTupleEvaluator> {
    protected final GFApplyLambdaNode lambdaNode;
    protected OlapTuple iTuple;

    public GFLambdaTupleEvaluator(GFTupleEvaluator other, GFApplyLambdaNode lambdaNode) {
        super(other);
        this.lambdaNode = lambdaNode;
    }

    public OlapScalarEntity evaluateAsScalar(GFContext context, GFMiniTupleEvaluator miniTupleEvaluator, OlapTupleSet set, OlapTuple iTuple, int iTupleOrdinal) {
        OlapEntity[] res = new OlapEntity[1];
        this.evaluate(context, miniTupleEvaluator, res, set.asIdentifiableSet(), iTuple, iTupleOrdinal, null);
        OlapEntity value = res[0];
        if (value instanceof OlapScalarEntity) {
            return (OlapScalarEntity)value;
        }
        throw new RuntimeException("lambda evaluation error: expecting a scalar value - got : " + value.getFriendlyTypeName());
    }

    public void evaluate(GFContext context, GFMiniTupleEvaluator miniTupleEvaluator, @Nullable OlapEntity[] res, @Nullable OlapTupleSet set, OlapTuple iTuple, int iTupleOrdinal, @Nullable GFApplyLambdaCallback callback) {
        miniTupleEvaluator.onIteratedTupleEvaluation(context, iTuple);
        this.setIteratedTuple(iTuple);
        GFTupleEvaluationFrame pushedCurrentTuple = this.pushEvaluatedTuple(context, iTuple);
        Object pushedIteratedTuple = null;
        if (set != null) {
            pushedIteratedTuple = context.pushIteratedTuple(set, iTuple, iTupleOrdinal);
        }
        if (callback != null) {
            callback.onBeforeLambdaExecution(context, iTuple);
        }
        OlapEntity evaluatedLambda1 = this.evalLambda(context, miniTupleEvaluator, this.lambdaNode.getLambda1());
        OlapEntity evaluatedLambda2 = null;
        if (this.lambdaNode.hasLambda2()) {
            evaluatedLambda2 = this.evalLambda(context, miniTupleEvaluator, this.lambdaNode.getLambda2());
        }
        if (callback != null) {
            callback.onAfterLambdaExecution(context);
            if (!this.lambdaNode.hasLambda2()) {
                if (evaluatedLambda1.isMdxNull()) {
                    callback.onEmptyValue(context, iTupleOrdinal, iTuple);
                } else if (evaluatedLambda1 instanceof OlapScalarEntity) {
                    callback.onScalarValue(context, iTupleOrdinal, iTuple, (OlapScalarEntity)evaluatedLambda1);
                } else {
                    callback.onNonScalarValue(context, iTupleOrdinal, iTuple, evaluatedLambda1);
                }
            } else if (evaluatedLambda1.isMdxNull() && evaluatedLambda2.isMdxNull()) {
                callback.onEmptyValue(context, iTupleOrdinal, iTuple);
            } else {
                callback.onScalarValue(context, iTupleOrdinal, iTuple, (OlapScalarEntity)evaluatedLambda1, (OlapScalarEntity)evaluatedLambda2);
            }
        }
        if (pushedIteratedTuple != null) {
            context.popIteratedTuple(pushedIteratedTuple);
        }
        if (pushedCurrentTuple != null) {
            context.popEvaluatedTuple(pushedCurrentTuple);
        }
        if (res != null) {
            res[0] = evaluatedLambda1;
        }
    }

    @Nullable
    public abstract GFTupleEvaluationFrame pushEvaluatedTuple(GFContext var1, OlapTuple var2);

    private OlapEntity evalLambda(GFContext context, GFMiniTupleEvaluator miniTupleEvaluator, @Nullable GFNode lambda) {
        OlapEntity evaluatedLambda = lambda != null && !lambda.isMissingArg() ? this.evalLambdaForLambdaTuple(context, miniTupleEvaluator, lambda) : this.evalLambdaForBlankTuple(context, miniTupleEvaluator);
        OlapEntity res = this.postEvalLambda(context, miniTupleEvaluator, evaluatedLambda);
        return res;
    }

    protected OlapEntity evalLambdaForLambdaTuple(GFContext context, GFMiniTupleEvaluator miniTupleEvaluator, GFNode lambda) {
        OlapEntity evaluatedLambda = lambda.execute(context, miniTupleEvaluator);
        return evaluatedLambda;
    }

    protected OlapEntity evalLambdaForBlankTuple(GFContext context, GFMiniTupleEvaluator miniTupleEvaluator) {
        OlapScalarEntity evaluatedLambda = miniTupleEvaluator.getValue(context, OlapBlankTuple.INSTANCE, false);
        return evaluatedLambda;
    }

    public void onFinally(GFContext context) {
    }

    public void setIteratedTuple(OlapTuple iTuple) {
        this.iTuple = iTuple;
    }

    protected OlapEntity postEvalLambda(GFContext context, GFMiniTupleEvaluator miniTupleEvaluator, OlapEntity entity) {
        if (this.lambdaNode.isEvaluatingScalarEntities() && !(entity instanceof OlapScalarEntity) && !entity.isMdxNull()) {
            if (entity instanceof OlapTuple) {
                OlapScalarEntity res = miniTupleEvaluator.getValue(context, (OlapTuple)entity, false);
                return res;
            }
            return (OlapEntity)this.lambdaNode.onFunctionArgTypeMismatchError(context, "expression", "scalar", entity.getFriendlyTypeName());
        }
        return entity;
    }
}

