/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator;

import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCacheKey;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCaches;
import crazydev.iccube.olap.eval.execinstr.gf.context.factcache.GFFactsTupleCacheMT;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFAbstractTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFStatementTupleEvaluator;
import crazydev.iccube.olap.eval.select.context.OlapCellsEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class GFCellsTupleEvaluator
extends GFAbstractTupleEvaluator<GFStatementTupleEvaluator> {
    private final GFCalcTupleCaches calcTupleCache;
    private final GFFactsTupleCacheMT evalCache;
    private OlapTupleDimensionality[] axisDim4Facts;
    private int axisCacheLength;
    private volatile boolean initialized;

    public GFCellsTupleEvaluator(OlapCellsEvaluationContext cellsEvaluationContext) {
        super(cellsEvaluationContext.getStatementContext().getTupleEvaluator());
        this.calcTupleCache = GFCalcTupleCaches.create(cellsEvaluationContext.getStatementContext());
        this.evalCache = new GFFactsTupleCacheMT(cellsEvaluationContext.getStatementContext());
        this.initialized = false;
    }

    @Override
    public boolean isAcceptingParallelLambdaProcessing() {
        return false;
    }

    @Override
    protected GFCellsTupleEvaluator resolveCells() {
        return this;
    }

    public void onCellValuesProcessed(OlapSelectStatementExecutionContext sContext) {
        this.evalCache.onCellValuesProcessed(sContext);
        this.calcTupleCache.onCellValuesProcessed(sContext);
    }

    public void init(OlapTuple[] cell) {
        if (this.initialized) {
            return;
        }
        this.axisCacheLength = 0;
        if (cell.length > 1) {
            int i;
            this.axisDim4Facts = new OlapTupleDimensionality[cell.length];
            for (i = 0; i < cell.length - 1; ++i) {
                this.axisDim4Facts[i] = GFCellsTupleEvaluator.calcAxisDim4Cache(cell, i);
            }
            for (i = cell.length - 1; i >= 0; --i) {
                if (this.axisDim4Facts[i] == null) continue;
                this.axisCacheLength = i + 1;
                break;
            }
        }
        this.initialized = true;
    }

    @Nullable
    private static OlapTupleDimensionality calcAxisDim4Cache(OlapTuple[] cell, int current) {
        int i;
        OlapTupleDimensionality dimensionality = cell[cell.length - 1].getTupleDimensionality();
        for (i = current + 1; i < cell.length - 2; ++i) {
            dimensionality = new OlapTupleDimensionality(dimensionality.unionEx(cell[i].getTupleDimensionality()));
        }
        for (i = 0; i < current + 1; ++i) {
            if (!cell[i].getTupleDimensionality().intersects(dimensionality)) continue;
            return null;
        }
        return dimensionality;
    }

    @Nullable
    protected OlapScalarEntity getFactsTupleFromCacheX(GFContext context, GFFactsEvalTuple evalTuple, Supplier<OlapScalarEntity> supplier) {
        if (!this.initialized) {
            throw new RuntimeException("internal error: inconsistent cells evaluation (missing initialization)");
        }
        OlapMeasureMember measure = evalTuple.getMeasure();
        Boolean measureCached = measure.isCached();
        if (measureCached != null && !measureCached.booleanValue()) {
            OlapScalarEntity value = supplier.get();
            return value;
        }
        OlapTupleDimensionality axisMembersDimensionality = evalTuple.getAxisTupleDimensionality();
        if (axisMembersDimensionality.isEmpty()) {
            OlapScalarEntity res = this.evalCache.getFromCache(context, evalTuple, supplier);
            return res;
        }
        for (int i = 0; i < this.axisCacheLength; ++i) {
            OlapTupleDimensionality axisDim4Fact = this.axisDim4Facts[i];
            if (axisDim4Fact == null || axisDim4Fact.intersects(axisMembersDimensionality)) continue;
            OlapScalarEntity res = this.evalCache.getFromCache(context, evalTuple, supplier);
            return res;
        }
        return null;
    }

    public boolean isWithGlobalCache(GFContext context, OlapCalculatedMember calcMember) {
        boolean withGlobalCache = this.calcTupleCache.acceptCalcMember(calcMember);
        return withGlobalCache;
    }

    @Override
    public OlapScalarEntity computeCalcTupleFromStatementCache(GFContext context, GFCalcTupleCacheKey tupleKey, Supplier<OlapScalarEntity> supplier) {
        OlapScalarEntity value = this.calcTupleCache.getValue(context, tupleKey, supplier);
        return value;
    }
}

