/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.tuple;

import crazydev.iccube.authorizationx.permissions.schema.OlapRoleDefaultCalcMembers;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleDefaultMembers;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeRef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapSubSelectCube;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapMemberOrigin;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFCalcMemberEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleVisibility;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFilteredOutEvalTuple;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.facts.IOlapFactMeasureGroupManagerForEval;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GFEvalTupleBuilder {
    private final GFContext context;
    private final OlapMdxStatementExecutionContext sContext;
    private final boolean noEmptyEvaluation;
    private final GFEvalTupleVisibility visibility;
    private final OlapMemberOrigin rawTupleOrigin;
    private final OlapMemberOrigin[] rawTupleOrigins;
    private final OlapTuple rawTuple;
    @Nullable
    private final OlapTupleDimensionality slicerAsSetDimensionality;
    private final boolean hasVisualSubSelect;
    private final OlapBitSet allMembersHierarchies;
    private final List<OlapMemberOrigin> allMembersOrigins;
    private final List<OlapMember> allMembers;
    @Nullable
    private OlapBitSet overwrittenHierarchies;
    @Nullable
    private OlapMemberOrigin highestPriorityMemberOrigin;
    @Nullable
    private OlapCalculatedMember highestPriorityMember;
    private boolean filteredOutDefaults;

    public GFEvalTupleBuilder(GFContext context, boolean noEmptyEvaluation, OlapMemberOrigin rawTupleOrigin, OlapMemberOrigin[] rawTupleOrigins, OlapTuple rawTuple) {
        this.context = context;
        this.sContext = context.getStatementExecutionContext();
        this.noEmptyEvaluation = noEmptyEvaluation;
        this.visibility = context.getEvalTupleVisibility();
        this.rawTupleOrigin = rawTupleOrigin;
        this.rawTupleOrigins = rawTupleOrigins;
        this.rawTuple = rawTuple;
        switch (this.visibility) {
            case STATIC: {
                this.slicerAsSetDimensionality = null;
                this.hasVisualSubSelect = false;
                break;
            }
            case DYNAMIC: {
                OlapResSlicer slicer = this.sContext.getSlicer();
                OlapSubSelectCube subSelect = this.sContext.getSubSelectCube();
                this.slicerAsSetDimensionality = slicer != null && slicer.isSet() ? slicer.getTupleDimensionality() : null;
                this.hasVisualSubSelect = subSelect != null && subSelect.isVisual();
                break;
            }
            case DYNAMIC_SLICER: {
                OlapResSlicer slicer = this.sContext.getSlicer();
                this.slicerAsSetDimensionality = slicer != null && slicer.isSet() ? slicer.getTupleDimensionality() : null;
                this.hasVisualSubSelect = false;
                break;
            }
            default: {
                throw new RuntimeException("internal error: unexpected tuple visibility [" + String.valueOf((Object)this.visibility) + "]");
            }
        }
        this.allMembersHierarchies = new OlapBitSet();
        this.allMembers = new ArrayList<OlapMember>();
        this.allMembersOrigins = new ArrayList<OlapMemberOrigin>();
    }

    public GFEvalTuple build(boolean isForContextMembers) {
        if (this.rawTuple.isFilteredOut()) {
            return this.buildFilteredOutEvalTuple();
        }
        this.completeFromRawTuple();
        this.completeFromRawTupleStack();
        this.completeFromSlicer();
        this.completeFromSubselect(this.sContext.getSubSelectCube());
        this.completeFromDefaultsCalcMembers();
        this.completeFromDefaultsMeasure();
        this.completeFromDefaults();
        OlapTupleDimensionality overwrittenHierarchiesD = !this.hasVisualSubSelect || this.overwrittenHierarchies == null || this.overwrittenHierarchies.isEmpty() ? null : new OlapTupleDimensionality(this.overwrittenHierarchies);
        OlapMeasureMember measure = null;
        int measurePos = -1;
        for (int ii = 0; ii < this.allMembers.size(); ++ii) {
            OlapMember member = this.allMembers.get(ii);
            if (!(member instanceof OlapMeasureMember)) continue;
            measurePos = ii;
            measure = (OlapMeasureMember)member;
            break;
        }
        if (this.noEmptyEvaluation && measure != null && this.highestPriorityMember == null) {
            OlapMeasureMember measureNE = measure.asNoEmptyMeasure();
            if (!OlapMember.equal(measureNE, measure) && measurePos != -1) {
                this.allMembers.set(measurePos, measureNE);
            }
            measure = measureNE;
        }
        List<S_RequestSubCubeRef> subCubes = this.context.getFactsSubCubes();
        S_VisualTotalsDef visualTotals = this.computeVisualMembers();
        if (this.highestPriorityMember != null || isForContextMembers) {
            return this.buildCalcMemberEvalTuple(measure, overwrittenHierarchiesD, subCubes, visualTotals);
        }
        if (this.filteredOutDefaults || measure == null) {
            return this.buildFilteredOutEvalTuple();
        }
        return this.buildFactsEvalTuple(measure, overwrittenHierarchiesD, subCubes, visualTotals);
    }

    protected void completeFromSubselect(OlapSubSelectCube subSelectCube) {
    }

    private GFEvalTuple buildFactsEvalTuple(OlapMeasureMember measure, OlapTupleDimensionality overwrittenHierarchies, List<S_RequestSubCubeRef> subCubes, S_VisualTotalsDef visualTotals) {
        OlapBitSet allMembersHierarchies_ = new OlapBitSet();
        ArrayList<OlapMemberOrigin> allMembersOrigins_ = new ArrayList<OlapMemberOrigin>();
        ArrayList<OlapMember> allMembers_ = new ArrayList<OlapMember>();
        OlapMemberOrigin measureOrigin = null;
        int size = this.allMembers.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapMemberOrigin origin = this.allMembersOrigins.get(ii);
            OlapMember member = this.allMembers.get(ii);
            if (member.isMeasure()) {
                measureOrigin = origin;
                continue;
            }
            if (origin == OlapMemberOrigin.SLICER || origin == OlapMemberOrigin.DEFAULTS) {
                OlapInstrExecListener listener;
                if (origin != OlapMemberOrigin.DEFAULTS || !this.context.hasInstrExecListener() || (listener = this.context.getInstrExecListener()) == null) continue;
                listener.onDefaultMember(member);
                continue;
            }
            allMembersHierarchies_.set(member.getTupleDimensionalityIndex());
            allMembersOrigins_.add(origin);
            allMembers_.add(member);
        }
        if (measureOrigin == null) {
            throw new RuntimeException("internal error: missing measure from all members [" + this.allMembers.toString() + "]");
        }
        OlapTupleDimensionality allMembersHierarchiesD_ = allMembersHierarchies_.isEmpty() ? OlapTupleDimensionalityFactory.createForBlankTuple() : (allMembers_.size() == 1 ? ((OlapMember)allMembers_.get(0)).getTupleDimensionality() : new OlapTupleDimensionality(allMembersHierarchies_));
        return new GFFactsEvalTuple(this, this.visibility, this.rawTupleOrigin, this.rawTupleOrigins, this.rawTuple, measureOrigin, measure, allMembersHierarchiesD_, allMembersOrigins_, allMembers_, overwrittenHierarchies, subCubes, visualTotals);
    }

    private GFEvalTuple buildCalcMemberEvalTuple(@Nullable OlapMeasureMember measure, @Nullable OlapTupleDimensionality overwrittenHierarchies, @Nullable List<S_RequestSubCubeRef> subCubes, @Nullable S_VisualTotalsDef visualTotals) {
        OlapTupleDimensionality allMembersHierarchiesD = this.allMembersHierarchies.isEmpty() ? OlapTupleDimensionalityFactory.createForBlankTuple() : (this.allMembers.size() == 1 ? this.allMembers.get(0).getTupleDimensionality() : new OlapTupleDimensionality(this.allMembersHierarchies));
        return new GFCalcMemberEvalTuple(this, this.visibility, this.rawTupleOrigin, this.rawTupleOrigins, this.rawTuple, this.highestPriorityMemberOrigin, this.highestPriorityMember, measure, allMembersHierarchiesD, this.allMembersOrigins, this.allMembers, overwrittenHierarchies, subCubes, visualTotals);
    }

    private GFEvalTuple buildFilteredOutEvalTuple() {
        return new GFFilteredOutEvalTuple(this, this.visibility, this.rawTupleOrigin, this.rawTupleOrigins, this.rawTuple);
    }

    private void completeFromTuple(OlapMemberOrigin origin, @Nullable OlapTuple tuple) {
        if (tuple == null) {
            return;
        }
        int count = tuple.getMemberCount();
        for (int ii = 0; ii < count; ++ii) {
            OlapMember member = tuple.getMember(ii);
            OlapHierarchy memberHierarchy = member.getHierarchy();
            if (this.hasHierarchy(memberHierarchy)) continue;
            this.addMembers(memberHierarchy, origin, tuple);
        }
    }

    private void completeFromTuple_(boolean inCalcMember, List<OlapMemberOrigin> origins, OlapTuple tuple) {
        if (tuple == null) {
            return;
        }
        int count = tuple.getMemberCount();
        for (int ii = 0; ii < count; ++ii) {
            OlapMember member = tuple.getMember(ii);
            OlapHierarchy memberHierarchy = member.getHierarchy();
            if (this.hasHierarchy(memberHierarchy)) continue;
            this.addMembers(memberHierarchy, inCalcMember, origins, tuple);
        }
    }

    private void completeFromRawTuple() {
        this.completeFromTuple(this.rawTupleOrigin, this.rawTuple);
    }

    private void completeFromRawTupleStack() {
        this.context.processTupleEvaluationFrames(frame -> {
            boolean inCalcMember = frame.isInCalcMemberEvaluation();
            List<OlapMemberOrigin> fOrigins = frame.origins();
            OlapTuple fTuple = frame.tuple();
            this.completeFromTuple_(inCalcMember, fOrigins, fTuple);
            return true;
        });
    }

    private void completeFromSlicer() {
        OlapMeasureMember measure;
        OlapMdxStatementExecutionContext sContext = this.context.getStatementExecutionContext();
        OlapResSlicer slicer = sContext.getSlicer();
        if (slicer == null) {
            return;
        }
        if (slicer.getTupleCount() == 1) {
            OlapTuple sTuple = slicer.getAnyTuple();
            int memberCount = sTuple.getMemberCount();
            for (int ii = 0; ii < memberCount; ++ii) {
                OlapMember sMember = sTuple.getMember(ii);
                OlapHierarchy sMemberHierarchy = sMember.getHierarchy();
                if (this.hasHierarchy(sMemberHierarchy)) continue;
                this.addMember(OlapMemberOrigin.SLICER, sMember);
            }
            return;
        }
        if (this.completeFromSetSlicer(slicer)) {
            return;
        }
        OlapCube cube = sContext.getCube().getUnderlying();
        OlapMeasuresDimension measuresD = cube.getMeasuresDimension();
        OlapHierarchy measuresH = measuresD.getBaseHierarchy();
        if (!this.allMembersHierarchies.get(measuresH.getTupleDimensionalityIndex()) && (measure = slicer.getMeasure(this.context)) != null) {
            this.addMember(OlapMemberOrigin.SLICER, measure);
        }
    }

    protected boolean completeFromSetSlicer(OlapResSlicer slicer) {
        return false;
    }

    private void completeFromDefaultsCalcMembers() {
        OlapRoleDefaultCalcMembers defaults = this.context.getDefaultAsCalcMembersFromPermissions();
        if (defaults == null || defaults.isNone()) {
            return;
        }
        int count = defaults.size();
        for (int ii = 0; ii < count; ++ii) {
            OlapCalculatedMember member = defaults.getMember(ii);
            OlapHierarchy hierarchy = member.getHierarchy();
            if (this.hasHierarchy(hierarchy)) continue;
            this.addMember(OlapMemberOrigin.DEFAULTS, member);
        }
    }

    private void completeFromDefaultsMeasure() {
        OlapMember defaultMeasure;
        OlapCube cube = this.sContext.getCube().getUnderlying();
        OlapMeasuresDimension measuresD = cube.getMeasuresDimension();
        OlapHierarchy measuresH = measuresD.getBaseHierarchy();
        if (!this.hasHierarchy(measuresH) && (defaultMeasure = measuresH.getNullableDefaultMember(this.context.getMemberFilter())) != null) {
            this.addMember(OlapMemberOrigin.DEFAULTS, defaultMeasure);
        }
    }

    private void completeFromDefaults() {
        OlapRoleDefaultMembers defaults;
        if (this.highestPriorityMember != null) {
            defaults = this.context.getDefaultsFromPermissions(null);
        } else {
            OlapMeasureMember measure = null;
            for (int ii = 0; ii < this.allMembers.size(); ++ii) {
                OlapMember member = this.allMembers.get(ii);
                if (!(member instanceof OlapMeasureMember)) continue;
                measure = (OlapMeasureMember)member;
                break;
            }
            if (measure != null) {
                IOlapFactMeasureGroupManagerForEval measureGroup = measure.getFactManager();
                defaults = this.context.getDefaultsFromPermissions(measureGroup);
            } else {
                defaults = this.context.getDefaultsFromPermissions(null);
            }
        }
        if (!defaults.isNone()) {
            this.addDefaultMembers(defaults);
        }
    }

    private void addDefaultMembers(OlapRoleDefaultMembers defaults) {
        int size = defaults.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapHierarchy hierarchy = defaults.getHierarchy(ii);
            if (this.hasHierarchy(hierarchy) || this.slicerAsSetDimensionality != null && this.slicerAsSetDimensionality.isIn(hierarchy)) continue;
            OlapMember member = defaults.getMember(ii);
            if (member == null) {
                this.filteredOutDefaults = true;
                continue;
            }
            this.addMember(OlapMemberOrigin.DEFAULTS, member);
        }
    }

    private void addMembers(OlapHierarchy hierarchy, OlapMemberOrigin origin, OlapTuple tuple) {
        int memberCount = tuple.getMemberCount();
        for (int ii = 0; ii < memberCount; ++ii) {
            OlapMember member = tuple.getMember(ii);
            OlapHierarchy memberHierarchy = member.getHierarchy();
            if (memberHierarchy != hierarchy) continue;
            this.addMember(origin, member);
        }
    }

    private void addMembers(OlapHierarchy hierarchy, boolean inCalcMember, List<OlapMemberOrigin> origins, OlapTuple tuple) {
        int memberCount = tuple.getMemberCount();
        for (int ii = 0; ii < memberCount; ++ii) {
            OlapMember member = tuple.getMember(ii);
            OlapHierarchy memberHierarchy = member.getHierarchy();
            if (memberHierarchy != hierarchy) continue;
            OlapMemberOrigin origin_ = this.hackOrigin(inCalcMember, origins.get(ii));
            this.addMember(origin_, member);
        }
    }

    private OlapMemberOrigin hackOrigin(boolean inCalcMember, OlapMemberOrigin origin) {
        switch (origin) {
            case AXIS: 
            case SLICER: 
            case DEFAULTS: 
            case CALC_MEMBER: {
                return origin;
            }
            case ROLLUP: 
            case I_TUPLE: 
            case LAMBDA_TUPLE: 
            case OTHER: {
                return inCalcMember ? OlapMemberOrigin.CALC_MEMBER : origin;
            }
        }
        throw new RuntimeException("internal error: unexpected member origin [" + String.valueOf((Object)origin) + "]");
    }

    final boolean containsMember(OlapMember member) {
        return this.allMembers.contains(member);
    }

    protected void addMember(OlapMemberOrigin origin, OlapMember member) {
        int hierarchy = member.getTupleDimensionalityIndex();
        this.allMembersOrigins.add(origin);
        this.allMembers.add(member);
        this.allMembersHierarchies.set(hierarchy);
        if (this.hasVisualSubSelect && origin == OlapMemberOrigin.CALC_MEMBER && !member.isMeasure() && !member.isCalculated()) {
            if (this.overwrittenHierarchies == null) {
                this.overwrittenHierarchies = new OlapBitSet();
            }
            this.overwrittenHierarchies.set(hierarchy);
        }
        if (member instanceof OlapCalculatedMember) {
            OlapCalculatedMember calcMember = (OlapCalculatedMember)member;
            if (this.highestPriorityMember == null) {
                this.highestPriorityMember = calcMember;
                this.highestPriorityMemberOrigin = origin;
            } else {
                this.highestPriorityMember = OlapCalculatedMember.highestPriorityMember(this.context.getEvalContext(), this.highestPriorityMember, calcMember);
                if (OlapMember.equal(this.highestPriorityMember, member)) {
                    this.highestPriorityMemberOrigin = origin;
                }
            }
        }
    }

    protected boolean hasHierarchy(OlapHierarchy hierarchy) {
        boolean inMembers = this.allMembersHierarchies.get(hierarchy.getTupleDimensionalityIndex());
        return inMembers;
    }

    @Nullable
    private S_VisualTotalsDef computeVisualMembers() {
        if (this.highestPriorityMember != null || !this.sContext.isVisualTotalsActive()) {
            return null;
        }
        OlapBitSet vHierarchies = new OlapBitSet();
        ArrayList<List<OlapMember>> vMembers = null;
        int size = this.allMembers.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapMember member = this.allMembers.get(ii);
            List<OlapMember> visuals = this.sContext.getVisualMembers(member);
            if (visuals == null || visuals.isEmpty()) continue;
            if (vMembers == null) {
                vMembers = new ArrayList<List<OlapMember>>();
            }
            vMembers.add(visuals);
            OlapMember vMember = visuals.get(0);
            vHierarchies.set(vMember.getTupleDimensionalityIndex());
        }
        if (vMembers != null && !vMembers.isEmpty()) {
            OlapTupleDimensionality vDimensionality = new OlapTupleDimensionality(vHierarchies);
            return new S_VisualTotalsDef(vDimensionality, (List<List<OlapMember>>)vMembers);
        }
        return null;
    }

    protected OlapBitSet copyAllMembersHierarchies() {
        return new OlapBitSet(this.allMembersHierarchies);
    }

    void addSubSelectMember(OlapMember member) {
        this.removeDefaults(member);
        for (int i = 0; i < this.allMembers.size(); ++i) {
            OlapMember olapMember = this.allMembers.get(i);
            OlapMemberOrigin memberOrigin = this.allMembersOrigins.get(i);
            if (olapMember.getHierarchy() != member.getHierarchy() || memberOrigin == OlapMemberOrigin.AXIS || memberOrigin == OlapMemberOrigin.SLICER || memberOrigin == OlapMemberOrigin.SUBSELECT) continue;
            return;
        }
        this.addMember(OlapMemberOrigin.SUBSELECT, member);
    }

    private void removeDefaults(OlapMember member) {
        for (int i = 0; i < this.allMembers.size(); ++i) {
            OlapMember olapMember = this.allMembers.get(i);
            OlapMemberOrigin memberOrigin = this.allMembersOrigins.get(i);
            if (olapMember.getHierarchy() != member.getHierarchy() || memberOrigin != OlapMemberOrigin.DEFAULTS) continue;
            this.allMembers.remove(i);
            this.allMembersOrigins.remove(i);
            this.removeDefaults(member);
        }
    }
}

