/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.tuple.OlapTupleOrParenInstr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class GFTupleOrParenNode
extends GFNode {
    private final OlapTupleOrParenInstr instr;
    private final GFNode[] items;

    public GFTupleOrParenNode(boolean markedForValueEvaluation, OlapTupleOrParenInstr instr, GFNode[] items) {
        super(markedForValueEvaluation);
        this.instr = instr;
        this.items = items;
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.instr.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.instr.getMdxForDrillthrough();
    }

    @Override
    public boolean isConstrainedEnabled() {
        return false;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return null;
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        for (GFNode item : this.items) {
            item.forEachNode(consumer);
        }
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        IOlapPrepareContext prepareContext = context.getPrepareContext();
        ArrayList<OlapEntity> entities = new ArrayList<OlapEntity>();
        boolean hasExplicitSet = false;
        for (int ii = 0; ii < this.items.length; ++ii) {
            GFNode item = this.items[ii];
            OlapEntity entity = item.execute(context, evaluator);
            entities.add(entity);
            if (hasExplicitSet || !(entity instanceof OlapTupleSet) && !(entity instanceof OlapLevel)) continue;
            hasExplicitSet = true;
        }
        if (entities.size() == 1) {
            OlapEntity entity = (OlapEntity)entities.get(0);
            if (entity.isMdxNull() || entity.isToMemberApplicable(prepareContext)) {
                return OlapTupleFactory.instance(context, entities);
            }
            return entity;
        }
        if (hasExplicitSet) {
            return this.createCrossjoin(context, entities);
        }
        boolean hasTuple = false;
        for (OlapEntity entity : entities) {
            OlapTuple entityT;
            if (!(entity instanceof OlapTuple) || (entityT = (OlapTuple)entity).getMemberCount() <= 1) continue;
            hasTuple = true;
            break;
        }
        if (hasTuple) {
            ArrayList<OlapEntity> entitiesT = new ArrayList<OlapEntity>();
            for (OlapEntity entity : entities) {
                OlapTuple entityT;
                if (entity instanceof OlapTuple && (entityT = (OlapTuple)entity).getMemberCount() > 1) {
                    for (int ii = 0; ii < entityT.getMemberCount(); ++ii) {
                        entitiesT.add(entityT.getMember(ii));
                    }
                    continue;
                }
                entitiesT.add(entity);
            }
            return OlapTupleFactory.instance(context, entitiesT);
        }
        return OlapTupleFactory.instance(context, entities);
    }

    private OlapEntity createCrossjoin(GFContext context, List<OlapEntity> entities) {
        IOlapPrepareContext prepareContext = context.getPrepareContext();
        ArrayList sets = new ArrayList();
        for (int idx = 0; idx < entities.size(); ++idx) {
            OlapEntity entity = entities.get(idx);
            if (entity.isMdxNull()) continue;
            if (!entity.isToSetApplicable(prepareContext)) {
                return (OlapEntity)this.onExecutionError(prepareContext, OlapErrorCode.CROSSJOIN_TYPE_MISMATCH, new Serializable[]{Integer.valueOf(idx), entity.getFriendlyTypeName()});
            }
            sets.add(entity.toSet(prepareContext));
        }
        OlapIterator<OlapTuple> iterator = OlapIteratorFactory.crossjoin(context, true, sets);
        return OlapSetFactory.instance(iterator);
    }

    @Override
    public String toStringForDebugger() {
        return "(...)";
    }
}

