/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFFunctionCallNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import java.io.Serializable;

public abstract class GFMathFunctionCallNode
extends GFFunctionCallNode {
    public GFMathFunctionCallNode(boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args) {
        super(markedForValueEvaluation, functionCallInstr, functionCallArgInstrs, function, args);
    }

    @Override
    public final OlapEntity doEvaluate(GFContext context, GFTupleEvaluator evaluator) {
        this.assertArgumentCount(context);
        OlapEntity res = this.doEvalX(context, evaluator);
        return res;
    }

    protected void assertArgumentCount(GFContext context) {
        OlapFunctionArgs argsInfo = ((OlapFunction)this.getFunction()).getArgsInfo();
        if (this.args.length < argsInfo.from || Integer.MAX_VALUE != argsInfo.to && this.args.length > argsInfo.to) {
            throw new OlapFunctionEvaluationException((IOlapEvaluationExceptionContext)context, this.function.getName(), OlapErrorCode.FUNCTION_UNEXPECTED_ARGUMENT_COUNT, new Serializable[]{Integer.valueOf(this.args.length), argsInfo.toString()});
        }
    }

    protected abstract OlapEntity doEvalX(GFContext var1, GFTupleEvaluator var2);

    protected OlapEntity asNull() {
        return OlapEmptyEntity.INSTANCE;
    }

    protected OlapScalarEntity asEmpty() {
        return OlapEmptyEntity.INSTANCE;
    }

    protected OlapEntity asNull(GFContext context, GFTupleEvaluator cache, int argNb) {
        if (argNb >= this.args.length || this.args[argNb] == null) {
            return this.asNull();
        }
        OlapScalarEntity val = this.toValue(context, cache, argNb);
        return val;
    }

    protected OlapScalarEntity toValue(GFContext context, GFTupleEvaluator cache, int argNb) {
        GFNode arg = this.args[argNb];
        OlapEntity entity = arg.execute(context, cache);
        if (entity.isMdxNull()) {
            return this.asEmpty();
        }
        if (entity instanceof OlapScalarEntity) {
            return (OlapScalarEntity)entity;
        }
        if (entity.isToValueApplicable(context, cache)) {
            OlapScalarEntity val = entity.toValue(context, cache);
            return val;
        }
        return (OlapScalarEntity)this.onFunctionArgTypeMismatchError(context.getPrepareContext(), String.valueOf(argNb), "scalar", entity.getFriendlyTypeName());
    }
}

